/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.file;

import de.matrixweb.smaller.osgi.maven.MavenInstaller;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.util.tracker.ServiceTracker;

public class Watchdog
extends Thread {
    private static final FileFilter JAR_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.isFile() && file.getName().endsWith(".jar");
        }
    };
    private volatile boolean running = true;
    private final File directory;
    private final BundleContext context;
    private final ServiceTracker<MavenInstaller, MavenInstaller> tracker;
    private final Map<File, Long> lastUpdated = new HashMap<File, Long>();

    public Watchdog(String directory, BundleContext context, ServiceTracker<MavenInstaller, MavenInstaller> tracker) {
        super("Smaller-FileInstaller-Watchdog");
        this.directory = new File(directory);
        this.context = context;
        this.tracker = tracker;
    }

    void halt() {
        this.running = false;
    }

    @Override
    public void run() {
        boolean update = false;
        while (this.running) {
            try {
                Collection list = Arrays.asList(this.directory.listFiles(JAR_FILE_FILTER));
                ArrayList<File> toBeInstalled = new ArrayList<File>();
                for (File file : list) {
                    if (this.lastUpdated.containsKey(file) && this.lastUpdated.get(file) >= file.lastModified()) continue;
                    toBeInstalled.add(file);
                    this.lastUpdated.put(file, file.lastModified());
                }
                try {
                    ((MavenInstaller)this.tracker.waitForService(0L)).installOrUpdate(update, toBeInstalled.toArray(new File[toBeInstalled.size()]));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ArrayList current = new ArrayList(this.lastUpdated.keySet());
                current.removeAll(list);
                for (File file : current) {
                    String location = file.toURI().toString();
                    try {
                        this.context.getBundle(location).uninstall();
                        this.lastUpdated.remove(file);
                    }
                    catch (BundleException e) {
                        e.printStackTrace();
                    }
                }
                update = true;
                Thread.sleep(5000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

