/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.osgi.http;

import de.matrixweb.smaller.common.GlobalOptions;
import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.common.Version;
import de.matrixweb.smaller.common.Zip;
import de.matrixweb.smaller.pipeline.Pipeline;
import de.matrixweb.smaller.pipeline.Result;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.Type;
import de.matrixweb.smaller.resource.VFSResourceResolver;
import de.matrixweb.vfs.VFS;
import de.matrixweb.vfs.wrapped.JavaFile;
import de.matrixweb.vfs.wrapped.WrappedSystem;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Servlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(Servlet.class);
    private static final long serialVersionUID = -3500628755781284892L;
    private final Pipeline pipeline;

    public Servlet(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.info("Handle smaller request from {} {}", (Object)request.getRemoteAddr(), (Object)request.getRequestURI());
        ServletOutputStream out = response.getOutputStream();
        if ("/".equals(request.getRequestURI())) {
            this.executePipeline(request, response, (OutputStream)out);
        } else {
            PrintStream print = new PrintStream((OutputStream)out, false, "UTF-8");
            try {
                print.print("hallo welt");
            }
            finally {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executePipeline(HttpServletRequest request, HttpServletResponse response, OutputStream out) throws IOException {
        Context context = null;
        try {
            context = this.setUpContext((InputStream)request.getInputStream());
            VFSResourceResolver resolver = new VFSResourceResolver(context.vfs);
            if (!context.manifest.getProcessDescriptions().isEmpty()) {
                this.executeProcesses(context, (ResourceResolver)resolver, request);
            } else {
                this.executeTasks(context, (ResourceResolver)resolver, request);
            }
            Zip.zip((OutputStream)out, (File)context.targetDir);
            this.setResponseHeader(response, "OK", null);
        }
        catch (SmallerException e) {
            LOGGER.error("Error during smaller execution", (Throwable)e);
            this.handleSmallerException(response, e);
        }
        catch (InvalidRequestException e) {
            LOGGER.error(e.toString());
        }
        catch (IOException e) {
            LOGGER.error("Error during smaller execution", (Throwable)e);
            this.setResponseHeader(response, "ERROR", "Exception during execution");
        }
        finally {
            this.tearDownContext(context);
            IOUtils.closeQuietly((OutputStream)out);
        }
    }

    private void executeProcesses(Context context, ResourceResolver resolver, HttpServletRequest request) throws IOException {
        Version version = Version.getVersion((String)request.getHeader("X-Smaller-Spec-Version"));
        this.pipeline.execute(version, context.vfs, resolver, context.manifest, context.targetDir);
    }

    @Deprecated
    private void executeTasks(Context context, ResourceResolver resolver, HttpServletRequest request) throws IOException {
        Task task = context.manifest.getNext();
        while (task != null) {
            this.writeResults(context.vfs, this.pipeline.execute(Version.getVersion((String)request.getHeader("X-Smaller-Spec-Version")), context.vfs, resolver, task), context.targetDir, task);
            task = context.manifest.getNext();
        }
    }

    /*
     * Exception decompiling
     */
    private Context setUpContext(InputStream is) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void tearDownContext(Context context) throws IOException {
        if (context != null) {
            if (context.vfs != null) {
                context.vfs.dispose();
            }
            if (context.inputZip != null) {
                context.inputZip.delete();
            }
            if (context.sourceDir != null) {
                FileUtils.deleteDirectory((File)context.sourceDir);
            }
            if (context.targetDir != null) {
                FileUtils.deleteDirectory((File)context.targetDir);
            }
        }
    }

    private Context unzip(InputStream is) throws IOException {
        Context context = this.storeZip(is);
        File base = File.createTempFile("smaller-work", ".dir");
        try {
            base.delete();
            base.mkdir();
            Zip.unzip((File)context.inputZip, (File)base);
        }
        catch (IOException e) {
            FileUtils.deleteDirectory((File)base);
            if (context.inputZip != null) {
                context.inputZip.delete();
            }
            throw e;
        }
        context.vfs.mount(context.vfs.find("/"), (WrappedSystem)new JavaFile(base));
        context.sourceDir = base;
        return context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Context storeZip(InputStream in) throws IOException {
        File temp = File.createTempFile("smaller-input", ".zip");
        try {
            temp.delete();
            FileOutputStream out = null;
            try {
                if (in.available() <= 0) {
                    throw new InvalidRequestException("Invalid attachment size; rejecting request");
                }
                out = new FileOutputStream(temp);
                IOUtils.copy((InputStream)in, (OutputStream)out);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)in);
            IOUtils.closeQuietly((OutputStream)out);
        }
        catch (IOException e) {
            FileUtils.deleteDirectory((File)temp);
            throw e;
        }
        Context context = new Context();
        context.inputZip = temp;
        return context;
    }

    private File getMainFile(File input) {
        File main = new File(input, "META-INF/smaller.json");
        if (!(main.exists() || (main = new File(input, "META-INF/MAIN.json")).exists() || (main = new File(input, "MAIN.json")).exists())) {
            throw new SmallerException("Missing instructions file 'META-INF/smaller.json'");
        }
        return main;
    }

    @Deprecated
    private void writeResults(VFS vfs, Result result, File outputDir, Task task) throws IOException {
        if (!GlobalOptions.isOutOnly((Task)task)) {
            vfs.exportFS(outputDir);
        }
        this.writeResult(outputDir, task, result, Type.JS);
        this.writeResult(outputDir, task, result, Type.CSS);
        this.writeResult(outputDir, task, result, Type.SVG);
    }

    @Deprecated
    private void writeResult(File output, Task task, Result result, Type type) throws IOException {
        String outputFile = this.getTargetFile(output, task.getOut(), type);
        if (outputFile != null) {
            FileUtils.writeStringToFile((File)new File(outputFile), (String)result.get(type).getContents());
        }
    }

    private String getTargetFile(File base, String[] out, Type type) {
        String target = null;
        block5: for (String s : out) {
            String ext = FilenameUtils.getExtension((String)s);
            switch (type) {
                case JS: {
                    if (!ext.equals("js")) continue block5;
                    target = new File(base, s).getAbsolutePath();
                    continue block5;
                }
                case CSS: {
                    if (!ext.equals("css")) continue block5;
                    target = new File(base, s).getAbsolutePath();
                    continue block5;
                }
                case SVG: {
                    if (!ext.equals("svg")) continue block5;
                    target = new File(base, s).getAbsolutePath();
                    continue block5;
                }
                default: {
                    throw new SmallerException("Invalid resource type " + type);
                }
            }
        }
        return target;
    }

    private void handleSmallerException(HttpServletResponse response, SmallerException e) {
        StringBuilder message = new StringBuilder(e.getMessage());
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            message.append(": ").append(t.getMessage());
        }
        this.setResponseHeader(response, "ERROR", message.toString().replace("\n", "#@@#"));
    }

    private void setResponseHeader(HttpServletResponse response, String status, String message) {
        response.setHeader("X-Smaller-Status", status);
        if (message != null) {
            response.setHeader("X-Smaller-Message", message);
        }
    }

    private static class InvalidRequestException
    extends IOException {
        private static final long serialVersionUID = 4298402581130531621L;

        public InvalidRequestException(String message) {
            super(message);
        }
    }

    private static class Context {
        private File inputZip;
        private File sourceDir;
        private File targetDir;
        private Manifest manifest;
        private final VFS vfs = new VFS();

        private Context() {
        }

        static /* synthetic */ File access$202(Context x0, File x1) {
            x0.targetDir = x1;
            return x0.targetDir;
        }

        static /* synthetic */ Manifest access$102(Context x0, Manifest x1) {
            x0.manifest = x1;
            return x0.manifest;
        }
    }
}

