/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.nodejs;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceGroup;
import de.matrixweb.smaller.resource.vfs.VFS;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodejsExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodejsExecutor.class);
    private final String version = "0.10.18";
    private final ObjectMapper om = new ObjectMapper();
    private Process process;
    private File workingDir;
    private BufferedWriter output;
    private BufferedReader input;

    public NodejsExecutor() {
        try {
            this.setupBinary();
        }
        catch (SmallerException e) {
            if (this.workingDir != null) {
                this.cleanupBinary();
            }
            throw e;
        }
    }

    private final void setupBinary() {
        try {
            this.workingDir = File.createTempFile("nodejs-v" + this.version, ".dir");
            this.workingDir.delete();
            this.workingDir.mkdirs();
            this.extractBinary(this.workingDir);
        }
        catch (IOException e) {
            throw new SmallerException("Unable to setup the node folder", (Throwable)e);
        }
    }

    private final void cleanupBinary() {
        try {
            FileUtils.deleteDirectory((File)this.workingDir);
        }
        catch (IOException e) {
            LOGGER.warn("Failed to delete node.js process directory", (Throwable)e);
        }
    }

    private final void extractBinary(File target) throws IOException {
        File node = new File(target, this.getPlatformExecutable());
        this.copyFile("/v" + this.version + "/" + this.getPlatformPath() + "/" + this.getPlatformExecutable(), node);
        node.setExecutable(true, true);
        this.copyFile("/v" + this.version + "/ipc.js", new File(target, "ipc.js"));
    }

    private final String getPlatformPath() {
        StringBuilder sb = new StringBuilder();
        if (SystemUtils.IS_OS_WINDOWS) {
            sb.append("win");
        } else if (SystemUtils.IS_OS_MAC_OSX) {
            sb.append("macos");
        } else if (SystemUtils.IS_OS_LINUX) {
            sb.append("linux");
        }
        if (SystemUtils.OS_ARCH.contains("64")) {
            sb.append("-x86_64");
        } else {
            sb.append("-x86");
        }
        return sb.toString();
    }

    private final String getPlatformExecutable() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return "node.exe";
        }
        return "node";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void copyFile(String inputFile, File outputFile) throws IOException {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(inputFile);
            if (in == null) {
                throw new FileNotFoundException(inputFile);
            }
            FileUtils.copyInputStreamToFile((InputStream)in, (File)outputFile);
        }
        finally {
            if (in != null) {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public void addModule(Class<?> clazz, String path) throws IOException {
        Enumeration<URL> urls = clazz.getClassLoader().getResources(path);
        while (urls.hasMoreElements()) {
            this.copyModuleToWorkingDirectory(urls.nextElement());
        }
    }

    private void copyModuleToWorkingDirectory(URL url) throws IOException {
        block4: {
            try {
                if ("file".equals(url.getProtocol())) {
                    this.copyModuleFromFolder(url);
                    break block4;
                }
                if ("jar".equals(url.getProtocol())) {
                    this.copyModuleFromJar(url);
                    break block4;
                }
                throw new SmallerException("Unsupported url schema: " + url);
            }
            catch (URISyntaxException e) {
                throw new IOException("Invalid uri syntax", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyModuleFromJar(URL url) throws IOException {
        String str = url.toString();
        String path = str.substring(str.indexOf(33) + 2);
        str = str.substring("jar:file:".length(), str.indexOf(33));
        JarFile jar = new JarFile(str);
        try {
            Enumeration<JarEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                if (!entry.getName().startsWith(path) || entry.isDirectory()) continue;
                File target = new File(this.workingDir, entry.getName().substring(path.length()));
                target.getParentFile().mkdirs();
                InputStream in = jar.getInputStream(entry);
                FileUtils.copyInputStreamToFile((InputStream)in, (File)target);
            }
        }
        finally {
            jar.close();
        }
    }

    private void copyModuleFromFolder(URL url) throws URISyntaxException, IOException {
        File file = new File(url.toURI());
        if (file.isDirectory()) {
            FileUtils.copyDirectory((File)file, (File)this.workingDir);
        } else {
            FileUtils.copyFileToDirectory((File)file, (File)this.workingDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public Resource run(VFS vfs, Resource resource, Map<String, String> options) throws IOException {
        this.startNodeIfRequired();
        Process process = this.process;
        synchronized (process) {
            Resource input = null;
            input = resource instanceof ResourceGroup ? (Resource)((ResourceGroup)resource).getResources().get(0) : resource;
            File temp = File.createTempFile("smaller-node-resource", ".dir");
            try {
                Resource resource2;
                temp.delete();
                temp.mkdirs();
                File infolder = new File(temp, "input");
                infolder.mkdirs();
                File outfolder = new File(temp, "output");
                outfolder.mkdirs();
                vfs.exportFS(infolder);
                try {
                    String resultPath = this.callNode(input, infolder, outfolder, options);
                    vfs.stack();
                    vfs.importFS(outfolder);
                    resource2 = resultPath == null ? input : input.getResolver().resolve(resultPath);
                }
                catch (NodeJsException e) {
                    Resource resource3 = resource;
                    FileUtils.deleteDirectory((File)temp);
                    return resource3;
                }
                return resource2;
            }
            finally {
                FileUtils.deleteDirectory((File)temp);
            }
        }
    }

    private String callNode(Resource resource, File infolder, File outfolder, Map<String, String> options) throws IOException, JsonGenerationException, JsonMappingException, JsonParseException, NodeJsException {
        String resultPath = null;
        HashMap<String, Object> command = new HashMap<String, Object>();
        command.put("cwd", this.workingDir.getAbsolutePath());
        command.put("indir", infolder.getAbsolutePath());
        if (resource != null) {
            command.put("file", resource.getPath());
        }
        command.put("outdir", outfolder.getAbsolutePath());
        command.put("options", options);
        this.output.write(this.om.writeValueAsString(command) + '\n');
        this.output.flush();
        this.waitForResponse();
        String error = this.readStdError();
        if (error != null) {
            LOGGER.error(error);
            throw new NodeJsException();
        }
        Map map = (Map)this.om.readValue(this.input.readLine(), (TypeReference)new TypeReference<Map<String, Object>>(){});
        if (map.containsKey("stdout")) {
            for (String line : (List)map.get("stdout")) {
                LOGGER.info(line);
            }
        }
        if (map.containsKey("stderr")) {
            for (String line : (List)map.get("stderr")) {
                LOGGER.error(line);
            }
        }
        if (map.containsKey("error")) {
            LOGGER.error(map.get("error").toString());
            throw new NodeJsException();
        }
        if (map.containsKey("result")) {
            resultPath = map.get("result").toString();
        }
        return resultPath;
    }

    private void startNodeIfRequired() throws IOException {
        try {
            if (this.process != null) {
                this.process.exitValue();
            }
            try {
                ProcessBuilder builder = new ProcessBuilder(new File(this.workingDir, this.getPlatformExecutable()).getAbsolutePath(), "ipc.js").directory(this.workingDir);
                builder.environment().put("NODE_PATH", ".");
                this.process = builder.start();
            }
            catch (IOException e) {
                throw new SmallerException("Unable to start node.js process", (Throwable)e);
            }
            try {
                this.output = new BufferedWriter(new OutputStreamWriter(this.process.getOutputStream(), "UTF-8"));
                this.input = new BufferedReader(new InputStreamReader(this.process.getInputStream(), "UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            try {
                if (!"ipc-ready".equals(this.input.readLine())) {
                    throw new SmallerException("Unable to start node.js process:\n" + this.readStdError());
                }
            }
            catch (IOException e) {
                throw new SmallerException("Unable to start node.js process", (Throwable)e);
            }
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            // empty catch block
        }
    }

    private void waitForResponse() throws IOException {
        while (this.process.getInputStream().available() == 0 && this.process.getErrorStream().available() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private String readStdError() throws IOException {
        if (this.process.getErrorStream().available() > 0) {
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.process.getErrorStream()));
            String line = reader.readLine();
            while (line != null) {
                sb.append(line).append('\n');
                line = reader.readLine();
            }
            return sb.toString();
        }
        return null;
    }

    public void dispose() {
        if (this.process != null) {
            this.process.destroy();
            this.process = null;
        }
        this.cleanupBinary();
    }

    private static class NodeJsException
    extends Exception {
        private static final long serialVersionUID = -1803769150577336117L;

        private NodeJsException() {
        }
    }
}

