/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.lessjs;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.javascript.JavaScriptExecutor;
import de.matrixweb.smaller.javascript.JavaScriptExecutorFast;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.ResourceResolver;
import de.matrixweb.smaller.resource.StringResource;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;

public class LessjsProcessor
implements Processor {
    private static final String WIN_LOC_HREF_FIX = "protocol://host:port/";
    private final ProxyResourceResolver proxy = new ProxyResourceResolver();
    private final JavaScriptExecutor executor;

    public LessjsProcessor() {
        this("1.3.3");
    }

    public LessjsProcessor(String version) {
        this(version, (JavaScriptExecutor)new JavaScriptExecutorFast("less-" + version, 9, LessjsProcessor.class));
    }

    LessjsProcessor(String version, JavaScriptExecutor executor) {
        this.executor = executor;
        this.executor.addGlobalFunction("resolve", (Object)new ResolveFunctor(this.proxy));
        this.executor.addScriptSource("win_loc_href_fix = 'protocol://host:port/';", "win_loc_href_fix");
        this.executor.addScriptFile(this.getClass().getResource("/lessjs/less-env.js"));
        this.executor.addScriptFile(this.getClass().getResource("/lessjs/less-" + version + ".js"));
        this.executor.addCallScript("lessIt(%s);");
    }

    public boolean supportsType(Type type) {
        return type == Type.CSS;
    }

    public Resource execute(Resource resource, Map<String, String> options) throws IOException {
        StringWriter writer = new StringWriter();
        this.proxy.setResolver(resource.getResolver());
        try {
            this.executor.run((Reader)new StringReader(resource.getContents()), (Writer)writer);
        }
        finally {
            this.proxy.removeResolver();
        }
        return new StringResource(resource.getResolver(), resource.getType(), resource.getPath(), writer.toString().replace(WIN_LOC_HREF_FIX, ""));
    }

    public void dispose() {
        this.executor.dispose();
    }

    private static class ProxyResourceResolver
    implements ResourceResolver {
        private final ThreadLocal<ResourceResolver> resolver = new ThreadLocal();

        private ProxyResourceResolver() {
        }

        public Resource resolve(String path) {
            return this.resolver.get().resolve(path);
        }

        private void setResolver(ResourceResolver resolver) {
            this.resolver.set(resolver);
        }

        private void removeResolver() {
            this.resolver.remove();
        }
    }

    public static class ResolveFunctor {
        private final ResourceResolver resolver;

        private ResolveFunctor(ResourceResolver resolver) {
            this.resolver = resolver;
        }

        public String resolve(String input) {
            try {
                return this.resolver.resolve(input.replace(LessjsProcessor.WIN_LOC_HREF_FIX, "")).getContents();
            }
            catch (IOException e) {
                throw new SmallerException("Failed to resolve resource '" + input + "'", (Throwable)e);
            }
        }
    }
}

