/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.jpegtran;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.BinaryResource;
import de.matrixweb.smaller.resource.Processor;
import de.matrixweb.smaller.resource.Resource;
import de.matrixweb.smaller.resource.Type;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class JpegtranProcessor
implements Processor {
    public boolean supportsType(Type type) {
        return type == Type.IMAGE;
    }

    public Resource execute(Resource resource, Map<String, String> options) throws IOException {
        if (!resource.getPath().endsWith("jpg") && !resource.getPath().endsWith("jpeg")) {
            return resource;
        }
        try {
            ProcessBuilder pb = new ProcessBuilder("jpegtran", "-optimize");
            Process process = pb.start();
            IOUtils.write((byte[])((BinaryResource)resource).getBytes(), (OutputStream)process.getOutputStream());
            process.waitFor();
            return new BinaryResource(resource.getResolver(), resource.getType(), resource.getPath(), IOUtils.toByteArray((InputStream)process.getInputStream()));
        }
        catch (InterruptedException e) {
            throw new SmallerException("Execution of jpegtran interruped", (Throwable)e);
        }
    }

    public void dispose() {
    }
}

