/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.cssembed;

import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.resource.Resource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import net.nczonline.web.cssembed.CSSURLEmbedder;
import net.nczonline.web.datauri.DataURIGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Embedder
extends CSSURLEmbedder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Embedder.class);
    private static final Method GET_MIME_TYPE;
    private final Resource resource;

    public Embedder(Resource resource, Reader in, int options, boolean verbose, int maxUriLength, int maxImageSize) throws IOException {
        super(in, options, verbose, maxUriLength, maxImageSize);
        this.resource = resource;
    }

    @Override
    String getImageURIString(String url, String originalUrl) throws IOException {
        if (Embedder.isImage(url)) {
            try {
                Resource img = this.resource.getResolver().resolve(url);
                URL imgurl = img.getURL();
                if (imgurl == null) {
                    img = this.resource.getResolver().resolve(originalUrl);
                    imgurl = img.getURL();
                }
                if (imgurl != null) {
                    StringWriter writer = new StringWriter();
                    DataURIGenerator.generate((URL)imgurl, (Writer)writer, (String)((String)GET_MIME_TYPE.invoke(null, originalUrl, null)));
                    return writer.toString();
                }
                LOGGER.info("Skipping on {} - does not resolve to resource url", (Object)originalUrl);
            }
            catch (FileNotFoundException e) {
                LOGGER.info("Not resolvable resource {} - try default embedding", (Object)originalUrl);
            }
            catch (IllegalAccessException e) {
                LOGGER.info("Failed to fetch mime-type of {} - try default embedding", (Object)originalUrl, (Object)e);
            }
            catch (InvocationTargetException e) {
                LOGGER.info("Failed to fetch mime-type of {} - try default embedding", (Object)originalUrl, (Object)e.getTargetException());
            }
        }
        return super.getImageURIString(url, originalUrl);
    }

    static {
        try {
            GET_MIME_TYPE = DataURIGenerator.class.getDeclaredMethod("getMimeType", String.class, String.class);
            GET_MIME_TYPE.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new SmallerException("getMimeType is not found", (Throwable)e);
        }
    }
}

