/*
 * Decompiled with CFR 0.152.
 */
package net.nczonline.web.cssembed;

import jargs.gnu.CmdLineParser;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import net.nczonline.web.cssembed.CSSURLEmbedder;

public class CSSEmbed {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void main(String[] args) {
        block40: {
            boolean skipMissingFiles;
            boolean mhtml;
            boolean verbose = false;
            String charset = null;
            String outputFilename = null;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            Writer out = null;
            InputStreamReader in = null;
            int options = 1;
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option verboseOpt = parser.addBooleanOption('v', "verbose");
            CmdLineParser.Option helpOpt = parser.addBooleanOption('h', "help");
            CmdLineParser.Option charsetOpt = parser.addStringOption("charset");
            CmdLineParser.Option rootOpt = parser.addStringOption("root");
            CmdLineParser.Option outputFilenameOpt = parser.addStringOption('o', "output");
            CmdLineParser.Option mhtmlOpt = parser.addBooleanOption("mhtml");
            CmdLineParser.Option mhtmlRootOpt = parser.addStringOption("mhtmlroot");
            CmdLineParser.Option skipMissingOpt = parser.addBooleanOption("skip-missing");
            CmdLineParser.Option uriLengthOpt = parser.addIntegerOption("max-uri-length");
            CmdLineParser.Option imageSizeOpt = parser.addIntegerOption("max-image-size");
            parser.parse(args);
            Boolean help = (Boolean)parser.getOptionValue(helpOpt);
            if (help != null && help.booleanValue()) {
                CSSEmbed.usage();
                System.exit(0);
            }
            verbose = parser.getOptionValue(verboseOpt) != null;
            charset = (String)parser.getOptionValue(charsetOpt);
            if (charset == null || !Charset.isSupported(charset)) {
                charset = System.getProperty("file.encoding");
                if (charset == null) {
                    charset = "UTF-8";
                }
                if (verbose) {
                    System.err.println("\n[INFO] Using charset " + charset);
                }
            }
            String[] fileArgs = parser.getRemainingArgs();
            String inputFilename = null;
            if (fileArgs.length == 0) {
                in = new InputStreamReader(System.in, charset);
            } else {
                inputFilename = fileArgs[0];
                in = new InputStreamReader((InputStream)new FileInputStream(inputFilename), charset);
            }
            int uriLength = 32768;
            Integer maxUriLength = (Integer)parser.getOptionValue(uriLengthOpt);
            if (maxUriLength != null && (uriLength = maxUriLength.intValue()) < 0) {
                uriLength = 0;
            }
            int imageSize = 0;
            Integer imageSizeOption = (Integer)parser.getOptionValue(imageSizeOpt);
            if (imageSizeOption != null && (imageSize = imageSizeOption.intValue()) < 0) {
                imageSize = 0;
            }
            boolean bl = mhtml = parser.getOptionValue(mhtmlOpt) != null;
            if (mhtml) {
                options = 2;
            }
            String mhtmlRoot = (String)parser.getOptionValue(mhtmlRootOpt);
            if (mhtml && mhtmlRoot == null) {
                throw new Exception("Must use --mhtmlroot when using --mhtml.");
            }
            boolean bl2 = skipMissingFiles = parser.getOptionValue(skipMissingOpt) != null;
            if (skipMissingFiles) {
                options |= 4;
            }
            CSSURLEmbedder embedder = new CSSURLEmbedder(in, options, verbose, uriLength, imageSize);
            embedder.setMHTMLRoot(mhtmlRoot);
            ((Reader)in).close();
            in = null;
            String root = (String)parser.getOptionValue(rootOpt);
            if (root == null) {
                if (inputFilename != null) {
                    root = new File(inputFilename).getCanonicalPath();
                    root = root.substring(0, root.lastIndexOf(File.separator));
                } else {
                    throw new Exception("Must use --root when not specifying a filename.");
                }
            }
            if (!root.endsWith(File.separator)) {
                root = root + File.separator;
            }
            if (verbose) {
                System.err.println("[INFO] Using '" + root + "' as root for relative file paths.");
            }
            if ((outputFilename = (String)parser.getOptionValue(outputFilenameOpt)) == null) {
                if (verbose) {
                    System.err.println("[INFO] No output file specified, defaulting to stdout.");
                }
                out = new OutputStreamWriter(System.out);
            } else {
                File outputFile = new File(outputFilename);
                if (verbose) {
                    System.err.println("[INFO] Output file is '" + outputFile.getAbsolutePath() + "'");
                }
                embedder.setFilename(outputFile.getName());
                out = new OutputStreamWriter((OutputStream)bytes, charset);
            }
            embedder.embedImages(out, root);
            if (out == null) break block40;
            try {
                out.close();
                if (bytes.size() > 0) {
                    bytes.writeTo(new FileOutputStream(outputFilename));
                }
                break block40;
            }
            catch (IOException e) {
                System.err.println("[ERROR] " + e.getMessage());
                if (verbose) {
                    e.printStackTrace();
                }
                break block40;
            }
            catch (CmdLineParser.OptionException e) {
                CSSEmbed.usage();
                System.exit(1);
                break block40;
            }
            catch (Exception e2) {
                System.err.println("[ERROR] " + e2.getMessage());
                if (verbose) {
                    e2.printStackTrace();
                }
                System.exit(1);
                break block40;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                block41: {
                    if (out != null) {
                        try {
                            out.close();
                            if (bytes.size() > 0) {
                                bytes.writeTo(new FileOutputStream(outputFilename));
                            }
                        }
                        catch (IOException e) {
                            System.err.println("[ERROR] " + e.getMessage());
                            if (!verbose) break block41;
                            e.printStackTrace();
                        }
                    }
                }
            }
        }
    }

    private static void usage() {
        System.out.println("\nUsage: java -jar cssembed-x.y.z.jar [options] [input file]\n\nGlobal Options\n  -h, --help            Displays this information.\n  --charset <charset>   Character set of the input file.\n  --mhtml               Enable MHTML mode.\n  --mhtmlroot <root>    Use <root> as the MHTML root for the file.\n  -v, --verbose         Display informational messages and warnings.\n  --root <root>         Prepends <root> to all relative URLs.\n  --skip-missing        Don't throw an error for missing image files.\n  --max-uri-length len  Maximum length for a data URI. Defaults to 32768.\n  --max-image-size size Maximum image size (in bytes) to convert.\n  -o <file>             Place the output into <file>. Defaults to stdout.");
    }
}

