/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.common;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.matrixweb.smaller.common.ProcessDescription;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.config.ConfigFile;
import de.matrixweb.smaller.config.Environment;
import de.matrixweb.smaller.config.Processor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Manifest {
    private List<ProcessDescription> processDescriptions;
    private final Map<String, Object> options = new HashMap<String, Object>();
    @Deprecated
    private Task[] tasks;
    @Deprecated
    @JsonIgnore
    private int current = -1;

    public static Manifest fromConfigFile(ConfigFile configFile) {
        Manifest manifest = new Manifest();
        for (Environment env : configFile.getEnvironments().values()) {
            ProcessDescription processDescription = new ProcessDescription();
            if (env.getPipeline() != null) {
                processDescription.setInputFile(((Processor)env.getProcessors().get(env.getPipeline()[0])).getSrc());
            }
            if (env.getProcess() != null) {
                processDescription.setOutputFile(env.getProcess());
            }
            if (env.getPipeline() != null) {
                for (String name : env.getPipeline()) {
                    ProcessDescription.Processor processor = new ProcessDescription.Processor();
                    processor.setName(name);
                    Processor p = (Processor)env.getProcessors().get(name);
                    if (p != null) {
                        processor.getOptions().putAll(p.getPlainOptions());
                    }
                    processDescription.getProcessors().add(processor);
                }
            }
            manifest.getProcessDescriptions().add(processDescription);
        }
        return manifest;
    }

    public Manifest() {
    }

    public List<ProcessDescription> getProcessDescriptions() {
        if (this.processDescriptions == null) {
            this.processDescriptions = new ArrayList<ProcessDescription>();
        }
        return this.processDescriptions;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    @Deprecated
    public Manifest(Task[] tasks) {
        this.tasks = tasks;
    }

    @Deprecated
    public Manifest(Task task) {
        this.tasks = new Task[]{task};
    }

    @Deprecated
    public final Task[] getTasks() {
        if (this.tasks == null) {
            return new Task[0];
        }
        return this.tasks;
    }

    @Deprecated
    public final void setTasks(Task[] tasks) {
        this.tasks = tasks;
    }

    @Deprecated
    public final Task getCurrent() {
        return this.tasks[this.current];
    }

    @JsonIgnore
    @Deprecated
    public final Task getNext() {
        ++this.current;
        if (this.tasks.length == this.current) {
            return null;
        }
        return this.tasks[this.current];
    }
}

