/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.common;

import java.util.Arrays;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Version {
    UNDEFINED(0, 0, 0),
    _1_0_0(1, 0, 0);

    public static final String HEADER = "X-Smaller-Spec-Version";
    private int major;
    private int minor;
    private int patch;

    private Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version getCurrentVersion() {
        return _1_0_0;
    }

    public static Version getVersion(String str) {
        try {
            String[] parts = str.split("\\.");
            String ver = "_" + parts[0] + "_" + parts[1] + "_" + parts[2];
            return Version.valueOf(ver);
        }
        catch (Exception exception) {
            return UNDEFINED;
        }
    }

    public boolean isAtLeast(Version version) {
        List<Version> versions = Arrays.asList(Version.values());
        return versions.indexOf((Object)this) >= versions.indexOf((Object)version);
    }

    public String toString() {
        return this.major + "." + this.minor + "." + this.patch;
    }
}

