/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.lang3.BooleanUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Task {
    private String processor;
    private String[] in;
    private String[] out;
    private String optionsDefinition;
    private transient Map<String, Map<String, String>> parsedOptions;

    public Task() {
    }

    public Task(String processor, String[] in, String[] out) {
        this.processor = processor;
        this.setIn(in);
        this.setOut(out);
    }

    public Task(String processor, String in, String out) {
        this.processor = processor;
        this.in = in.split(",");
        this.out = out.split(",");
    }

    @Deprecated
    public Task(String processor, String in, String out, Set<Options> options) {
        this(processor, in, out);
        this.setOptions(options);
    }

    public Task(String processor, String in, String out, String optionsDefinition) {
        this(processor, in, out);
        this.optionsDefinition = optionsDefinition;
    }

    public final String getProcessor() {
        return this.processor;
    }

    public final void setProcessor(String processor) {
        this.processor = processor;
    }

    public final String[] getIn() {
        String[] result = new String[this.in.length];
        System.arraycopy(this.in, 0, result, 0, this.in.length);
        return result;
    }

    public final String[] getIn(String ... extensions) {
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = this.getIn();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            String[] stringArray2 = extensions;
            int n3 = extensions.length;
            int n4 = 0;
            while (n4 < n3) {
                String ext = stringArray2[n4];
                if (s.endsWith(ext)) {
                    list.add(s);
                }
                ++n4;
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public final void setIn(String[] in) {
        this.in = new String[in.length];
        System.arraycopy(in, 0, this.in, 0, in.length);
    }

    public final String[] getOut() {
        String[] result = new String[this.out.length];
        System.arraycopy(this.out, 0, result, 0, this.out.length);
        return result;
    }

    public final void setOut(String[] out) {
        this.out = new String[out.length];
        System.arraycopy(out, 0, this.out, 0, out.length);
    }

    @Deprecated
    public final Set<Options> getOptions() {
        return null;
    }

    @Deprecated
    public final void setOptions(Set<Options> options) {
        if (options != null && options.contains((Object)Options.OUT_ONLY)) {
            this.setOptionsDefinition("output:out-only=true");
        }
    }

    public final String getOptionsDefinition() {
        return this.optionsDefinition;
    }

    public Map<String, String> getOptionsFor(String processor) {
        if (this.parsedOptions == null) {
            this.parsedOptions = new HashMap<String, Map<String, String>>();
            if (this.optionsDefinition != null) {
                String[] stringArray = this.optionsDefinition.split(";");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String byProcessor = stringArray[n2];
                    StringTokenizer tokenizer = new StringTokenizer(byProcessor, ":");
                    String name = tokenizer.nextToken();
                    this.parsedOptions.put(name, new HashMap());
                    String[] stringArray2 = tokenizer.nextToken().split(",");
                    int n3 = stringArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        String option = stringArray2[n4];
                        tokenizer = new StringTokenizer(option, "=");
                        this.parsedOptions.get(name).put(tokenizer.nextToken(), tokenizer.nextToken());
                        ++n4;
                    }
                    ++n2;
                }
            }
        }
        if (!this.parsedOptions.containsKey(processor)) {
            return Collections.emptyMap();
        }
        return this.parsedOptions.get(processor);
    }

    public final void setOptionsDefinition(String optionsDefinition) {
        this.optionsDefinition = optionsDefinition;
    }

    public static class GlobalOptions {
        public static boolean isOutOnly(Task task) {
            return BooleanUtils.toBoolean((String)task.getOptionsFor("output").get("out-only"));
        }

        public static boolean isSourceOnce(Task task) {
            return BooleanUtils.toBoolean((String)task.getOptionsFor("source").get("once"));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Options {
        OUT_ONLY;

    }
}

