/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class Task {
    private String processor;
    private String[] in;
    private String[] out;
    private String optionsDefinition;
    private transient Map<String, Map<String, String>> parsedOptions;

    public Task() {
    }

    public Task(String processor, String[] in, String[] out) {
        this.processor = processor;
        this.in = in;
        this.out = out;
    }

    public Task(String processor, String in, String out) {
        this.processor = processor;
        this.in = in.split(",");
        this.out = out.split(",");
    }

    @Deprecated
    public Task(String processor, String in, String out, Set<Options> options) {
        this(processor, in, out);
        this.setOptions(options);
    }

    public Task(String processor, String in, String out, String optionsDefinition) {
        this(processor, in, out);
        this.optionsDefinition = optionsDefinition;
    }

    public final String getProcessor() {
        return this.processor;
    }

    public final void setProcessor(String processor) {
        this.processor = processor;
    }

    public final String[] getIn() {
        return this.in;
    }

    public final String[] getIn(String ... extensions) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : this.getIn()) {
            for (String ext : extensions) {
                if (!s.endsWith(ext)) continue;
                list.add(s);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    public final void setIn(String[] in) {
        this.in = in;
    }

    public final String[] getOut() {
        return this.out;
    }

    public final void setOut(String[] out) {
        this.out = out;
    }

    @Deprecated
    public final Set<Options> getOptions() {
        return null;
    }

    @Deprecated
    public final void setOptions(Set<Options> options) {
        if (options != null && options.contains((Object)Options.OUT_ONLY)) {
            this.setOptionsDefinition("output:out-only=true");
        }
    }

    public final String getOptionsDefinition() {
        return this.optionsDefinition;
    }

    public Map<String, String> getOptionsFor(String processor) {
        if (this.parsedOptions == null) {
            this.parsedOptions = new HashMap<String, Map<String, String>>();
            if (this.optionsDefinition != null) {
                for (String byProcessor : this.optionsDefinition.split(";")) {
                    StringTokenizer tokenizer = new StringTokenizer(byProcessor, ":");
                    String name = tokenizer.nextToken();
                    this.parsedOptions.put(name, new HashMap());
                    for (String option : tokenizer.nextToken().split(",")) {
                        tokenizer = new StringTokenizer(option, "=");
                        this.parsedOptions.get(name).put(tokenizer.nextToken(), tokenizer.nextToken());
                    }
                }
            }
        }
        if (!this.parsedOptions.containsKey(processor)) {
            return Collections.emptyMap();
        }
        return this.parsedOptions.get(processor);
    }

    public final void setOptionsDefinition(String optionsDefinition) {
        this.optionsDefinition = optionsDefinition;
    }

    public static enum Options {
        OUT_ONLY;

    }
}

