// Generated by CoffeeScript 1.5.0
(function() {
  var CoffeeScript, addMultilineHandler, merge, nodeREPL, replDefaults, vm;

  vm = require('vm');

  nodeREPL = require('repl');

  CoffeeScript = require('./coffee-script');

  merge = require('./helpers').merge;

  replDefaults = {
    prompt: 'coffee> ',
    "eval": function(input, context, filename, cb) {
      var js;
      input = input.replace(/\uFF00/g, '\n');
      input = input.replace(/(^|[\r\n]+)(\s*)##?(?:[^#\r\n][^\r\n]*|)($|[\r\n])/, '$1$2$3');
      if (/^\s*$/.test(input)) {
        return cb(null);
      }
      try {
        js = CoffeeScript.compile("_=(" + input + "\n)", {
          filename: filename,
          bare: true
        });
      } catch (err) {
        cb(err);
      }
      return cb(null, vm.runInContext(js, context, filename));
    }
  };

  addMultilineHandler = function(repl) {
    var inputStream, multiline, nodeLineListener, outputStream, rli;
    rli = repl.rli, inputStream = repl.inputStream, outputStream = repl.outputStream;
    multiline = {
      enabled: false,
      initialPrompt: repl.prompt.replace(/^[^> ]*/, function(x) {
        return x.replace(/./g, '-');
      }),
      prompt: repl.prompt.replace(/^[^> ]*>?/, function(x) {
        return x.replace(/./g, '.');
      }),
      buffer: ''
    };
    nodeLineListener = rli.listeners('line')[0];
    rli.removeListener('line', nodeLineListener);
    rli.on('line', function(cmd) {
      if (multiline.enabled) {
        multiline.buffer += "" + cmd + "\n";
        rli.setPrompt(multiline.prompt);
        rli.prompt(true);
      } else {
        nodeLineListener(cmd);
      }
    });
    return inputStream.on('keypress', function(char, key) {
      if (!(key && key.ctrl && !key.meta && !key.shift && key.name === 'v')) {
        return;
      }
      if (multiline.enabled) {
        if (!multiline.buffer.match(/\n/)) {
          multiline.enabled = !multiline.enabled;
          rli.setPrompt(repl.prompt);
          rli.prompt(true);
          return;
        }
        if ((rli.line != null) && !rli.line.match(/^\s*$/)) {
          return;
        }
        multiline.enabled = !multiline.enabled;
        rli.line = '';
        rli.cursor = 0;
        rli.output.cursorTo(0);
        rli.output.clearLine(1);
        multiline.buffer = multiline.buffer.replace(/\n/g, '\uFF00');
        rli.emit('line', multiline.buffer);
        multiline.buffer = '';
      } else {
        multiline.enabled = !multiline.enabled;
        rli.setPrompt(multiline.initialPrompt);
        rli.prompt(true);
      }
    });
  };

  module.exports = {
    start: function(opts) {
      var repl;
      if (opts == null) {
        opts = {};
      }
      opts = merge(replDefaults, opts);
      repl = nodeREPL.start(opts);
      repl.on('exit', function() {
        return repl.outputStream.write('\n');
      });
      addMultilineHandler(repl);
      return repl;
    }
  };

}).call(this);
