/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.common;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.common.Logger;
import de.matrixweb.smaller.common.Manifest;
import de.matrixweb.smaller.common.SmallerException;
import de.matrixweb.smaller.common.Task;
import de.matrixweb.smaller.common.Zip;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.codehaus.jackson.map.ObjectMapper;

public class Util {
    private final Logger logger;
    private boolean debug = false;

    public Util(Logger logger) {
        this(logger, false);
    }

    public Util(Logger logger, boolean debug) {
        this.logger = logger;
        this.debug = debug;
    }

    public byte[] zip(File base, String[] includedFiles, String processor, String in, String out) throws ExecutionException {
        return this.zip(base, includedFiles, processor, in, out, "");
    }

    public byte[] zip(File base, String[] includedFiles, String processor, String in, String out, String options) throws ExecutionException {
        return this.zip(base, includedFiles, new Task[]{this.createTask(processor, in, out, options)});
    }

    public byte[] zip(File base, String[] includedFiles, Task[] tasks) throws ExecutionException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            File temp = File.createTempFile("maven-smaller", ".dir");
            temp.delete();
            temp.mkdirs();
            Manifest manifest = this.writeManifest(temp, tasks);
            try {
                File target;
                String[] stringArray = includedFiles;
                int n = includedFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    String includedFile = stringArray[n2];
                    this.logger.debug("Adding " + includedFile + " to zip");
                    target = new File(temp, includedFile);
                    target.getParentFile().mkdirs();
                    FileUtils.copyFile((File)new File(base, includedFile), (File)target);
                    ++n2;
                }
                stringArray = manifest.getTasks()[0].getIn();
                n = stringArray.length;
                n2 = 0;
                while (n2 < n) {
                    String included = stringArray[n2];
                    target = new File(temp, included);
                    target.getParentFile().mkdirs();
                    FileUtils.copyFile((File)new File(base, included), (File)target);
                    ++n2;
                }
                Zip.zip((OutputStream)baos, (File)temp);
            }
            finally {
                if (!this.debug) {
                    FileUtils.deleteDirectory((File)temp);
                } else {
                    this.logger.debug("Path to input files: " + temp);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to create zip file for upload", e);
        }
    }

    private Task createTask(String processor, String in, String out, String options) {
        return new Task(processor, in, out, options);
    }

    private Manifest writeManifest(File temp, Task[] task) throws ExecutionException {
        try {
            Manifest manifest = new Manifest(task);
            File metaInf = new File(temp, "META-INF");
            metaInf.mkdirs();
            new ObjectMapper().writeValue(new File(metaInf, "MAIN.json"), (Object)manifest);
            return manifest;
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to write manifest", e);
        }
    }

    public byte[] send(String host, String port, byte[] bytes) throws ExecutionException {
        return this.send(host, port, null, null, bytes);
    }

    public byte[] send(String host, String port, String proxyhost, String proxyport, byte[] bytes) throws ExecutionException {
        try {
            Request request = Request.Post((String)("http://" + host + ":" + port)).socketTimeout(0).connectTimeout(0);
            if (proxyhost != null && proxyport != null) {
                request.viaProxy(new HttpHost(proxyhost, Integer.valueOf(proxyport).intValue()));
            }
            HttpResponse response = request.bodyByteArray(bytes).execute().returnResponse();
            return this.handleResponse(response);
        }
        catch (Exception e) {
            if (e instanceof SmallerException) {
                throw (SmallerException)e;
            }
            throw new ExecutionException("Failed to send zip file", e);
        }
    }

    private byte[] handleResponse(HttpResponse response) throws IOException, ExecutionException {
        InputStream in = response.getEntity().getContent();
        try {
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ExecutionException(IOUtils.toString((InputStream)in));
            }
            if (this.getHeader(response, "X-Smaller-Status").equals("ERROR")) {
                throw new SmallerException(this.getHeader(response, "X-Smaller-Message").replace("#@@#", "\n"));
            }
            byte[] byArray = IOUtils.toByteArray((InputStream)in);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    private String getHeader(HttpResponse response, String name) {
        Header header = response.getFirstHeader(name);
        return header != null ? header.getValue() : "";
    }

    public void unzip(File target, byte[] bytes) throws ExecutionException {
        try {
            File temp = File.createTempFile("smaller", ".zip");
            temp.delete();
            FileOutputStream fos = new FileOutputStream(temp);
            try {
                IOUtils.write((byte[])bytes, (OutputStream)fos);
                target.mkdirs();
                Zip.unzip((File)temp, (File)target);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)fos);
                if (!this.debug) {
                    temp.delete();
                } else {
                    this.logger.debug("Path to output files: " + temp);
                }
            }
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to handle smaller response", e);
        }
    }
}

