/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public final class Zip {
    private Zip() {
    }

    public static void zip(OutputStream out, File dir) throws IOException {
        ZipOutputStream zos = new ZipOutputStream(out);
        Zip.recursiveZip(zos, dir, dir);
        zos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recursiveZip(ZipOutputStream zos, File root, File base) throws IOException {
        String[] dirList;
        for (String element : dirList = base.list()) {
            File f = new File(base, element);
            if (f.isDirectory()) {
                Zip.recursiveZip(zos, root, f);
                continue;
            }
            FileInputStream fis = new FileInputStream(f);
            try {
                if (!FilenameUtils.isExtension(f.getName(), Arrays.asList("js", "coffee", "ts", "json", "css", "less"))) {
                    Zip.writeDeflate(f, fis, zos, root);
                    continue;
                }
                Zip.writeStored(f, fis, zos, root);
            }
            finally {
                IOUtils.closeQuietly(fis);
            }
        }
    }

    private static void writeDeflate(File f, FileInputStream fis, ZipOutputStream zos, File root) throws IOException {
        ZipEntry anEntry = new ZipEntry(FilenameUtils.separatorsToUnix(StringUtils.removeStart(f.getPath(), root.getPath() + File.separator)));
        zos.putNextEntry(anEntry);
        IOUtils.copy((InputStream)fis, (OutputStream)zos);
        zos.closeEntry();
    }

    private static void writeStored(File f, FileInputStream fis, ZipOutputStream zos, File root) throws IOException {
        byte[] bytes = IOUtils.toByteArray(fis);
        CRC32 crc = new CRC32();
        crc.reset();
        crc.update(bytes);
        ZipEntry anEntry = new ZipEntry(FilenameUtils.separatorsToUnix(StringUtils.removeStart(f.getPath(), root.getPath() + File.separator)));
        anEntry.setMethod(0);
        anEntry.setCompressedSize(f.length());
        anEntry.setSize(f.length());
        anEntry.setCrc(crc.getValue());
        zos.putNextEntry(anEntry);
        IOUtils.write(bytes, (OutputStream)zos);
        zos.closeEntry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void unzip(File zip, File target) throws IOException {
        ZipFile zipFile = new ZipFile(zip);
        try {
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    FileUtils.forceMkdir(new File(target, entry.getName()));
                    continue;
                }
                FileUtils.forceMkdir(new File(target, entry.getName()).getParentFile());
                InputStream in = null;
                FileOutputStream out = null;
                try {
                    in = zipFile.getInputStream(entry);
                    out = new FileOutputStream(new File(target, entry.getName()));
                    IOUtils.copy(in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    throw throwable;
                    return;
                }
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
            }
        }
        finally {
            zipFile.close();
        }
    }
}

