/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.ant;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.common.Logger;
import de.matrixweb.smaller.clients.common.Util;
import de.matrixweb.smaller.config.ConfigFile;
import de.matrixweb.smaller.config.Environment;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SmallerTask
extends Task {
    private String host = "sr.s2.de";
    private String port = "80";
    private String proxyhost = null;
    private String proxyport = null;
    private File target;
    private boolean debug = false;
    private File configFilePath;

    public final void setHost(String host) {
        this.host = host;
    }

    public final void setPort(String port) {
        this.port = port;
    }

    public void setProxyhost(String proxyhost) {
        this.proxyhost = proxyhost;
    }

    public void setProxyport(String proxyport) {
        this.proxyport = proxyport;
    }

    public final void setTarget(File target) {
        this.target = target;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setConfigFile(File configFile) {
        this.configFilePath = configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() {
        try {
            Util util = new Util(new AntLogger(), this.debug);
            File temp = File.createTempFile("smaller-ant", ".dir");
            try {
                temp.delete();
                temp.mkdirs();
                this.log("Reading config-file: " + this.configFilePath);
                if (!this.configFilePath.exists()) {
                    throw new RuntimeException(this.configFilePath.toString());
                }
                ConfigFile configFile = ConfigFile.read(this.configFilePath);
                ArrayList<String> includedFiles = new ArrayList<String>();
                for (String envName : configFile.getBuildServer().getEnvironments()) {
                    Environment env = configFile.getEnvironments().get(envName);
                    for (String dir : env.getFiles().getFolder()) {
                        String[] included;
                        this.copyFirstInputFile(env, dir, temp);
                        String base = new File(this.configFilePath.getParentFile(), dir).getAbsolutePath();
                        for (String include : included = this.scanIncludedFiles(base, env.getFiles().getIncludes(), env.getFiles().getExcludes())) {
                            FileUtils.copyFile(new File(base, include), new File(temp, include));
                            includedFiles.add(include);
                        }
                    }
                }
                util.unzip(this.target, util.send(this.host, this.port, this.proxyhost, this.proxyport, util.zip(temp, includedFiles, configFile)));
            }
            finally {
                FileUtils.deleteDirectory(temp);
            }
        }
        catch (IOException e) {
            this.log(Util.formatException(e), 0);
            throw new BuildException("Failed execute smaller", e);
        }
        catch (ExecutionException e) {
            this.log(Util.formatException(e), 0);
            throw new BuildException("Failed execute smaller", e);
        }
    }

    private void copyFirstInputFile(Environment env, String dir, File temp) throws IOException {
        String input = env.getProcessors().get(env.getPipeline()[0]).getSrc();
        File inputFile = new File(new File(this.configFilePath.getParentFile(), dir), input);
        if (inputFile.exists()) {
            FileUtils.copyFile(inputFile, new File(temp, input));
        }
    }

    private String[] scanIncludedFiles(String dir, String[] includes, String[] excludes) {
        FileSet set = new FileSet();
        set.setProject(this.getProject());
        this.log("Scanning " + dir);
        set.setDir(new File(dir));
        set.appendIncludes(includes);
        set.appendExcludes(excludes);
        return set.getDirectoryScanner().getIncludedFiles();
    }

    private class AntLogger
    implements Logger {
        private AntLogger() {
        }

        public void debug(String message) {
            SmallerTask.this.log(message, 2);
        }
    }
}

