/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.smaller.clients.ant;

import de.matrixweb.smaller.clients.common.ExecutionException;
import de.matrixweb.smaller.clients.common.Logger;
import de.matrixweb.smaller.clients.common.Util;
import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class SmallerTask
extends Task {
    private String processor;
    private String in;
    private String out;
    private String options = "";
    private String host = "sr.s2.de";
    private String port = "80";
    private FileSet files;
    private File target;
    private boolean debug = false;

    public final void setProcessor(String processor) {
        this.processor = processor;
    }

    public final void setIn(String in) {
        this.in = in;
    }

    public final void setOut(String out) {
        this.out = out;
    }

    public void setOptions(String options) {
        this.options = options;
    }

    public final void setHost(String host) {
        this.host = host;
    }

    public final void setPort(String port) {
        this.port = port;
    }

    public final void setFiles(FileSet files) {
        this.files = files;
    }

    public final void addFileset(FileSet files) {
        if (this.files != null) {
            throw new BuildException("Only one fileset is allowed");
        }
        this.files = files;
    }

    public final void setTarget(File target) {
        this.target = target;
    }

    public final void setDebug(boolean debug) {
        this.debug = debug;
    }

    @Override
    public void execute() {
        try {
            Util util = new Util(new AntLogger(), this.debug);
            DirectoryScanner ds = this.files.getDirectoryScanner();
            util.unzip(this.target, util.send(this.host, this.port, util.zip(ds.getBasedir(), ds.getIncludedFiles(), this.processor, this.in, this.out, this.options)));
        }
        catch (ExecutionException e) {
            throw new BuildException("Failed execute smaller", e);
        }
    }

    private class AntLogger
    implements Logger {
        private AntLogger() {
        }

        @Override
        public void debug(String message) {
            SmallerTask.this.log(message, 2);
        }
    }
}

