"WeakMap" in this || (function (module) {"use strict";

  //!(C) WebReflection - Mit Style License
  // size and performances oriented polyfill for ES6
  // WeakMap, Map, and Set
  // compatible with node.js, Rhino, any browser
  // does not implement default vaule during wm.get()
  // since ES.next won't probably do that
  // use wm.has(o) ? wm.get(o) : d3fault; instead

  // WeakMap(void):WeakMap
  function WeakMap() {

    // private references holders
    var
      keys = [],
      values = []
    ;

    // returns freshly new created
    // instanceof WeakMap in any case
    return create(WeakMapPrototype, {
      // WeakMap#delete(key:void*):boolean
      "delete": {value: bind.call(sharedDel, NULL, TRUE, keys, values)},
      //:was WeakMap#get(key:void*[, d3fault:void*]):void*
      // WeakMap#get(key:void*):void*
      get:      {value: bind.call(sharedGet, NULL, TRUE, keys, values)},
      // WeakMap#has(key:void*):boolean
      has:      {value: bind.call(sharedHas, NULL, TRUE, keys, values)},
      // WeakMap#set(key:void*, value:void*):void
      set:      {value: bind.call(sharedSet, NULL, TRUE, keys, values)}
    });

  }

  // Map(void):Map
  function Map() {

    // private references holders
    var
      keys = [],
      values = []
    ;

    // returns freshly new created
    // instanceof WeakMap in any case
    return create(MapPrototype, {
      // Map#delete(key:void*):boolean
      "delete": {value: bind.call(sharedDel, NULL, FALSE, keys, values)},
      //:was Map#get(key:void*[, d3fault:void*]):void*
      // Map#get(key:void*):void*
      get:      {value: bind.call(sharedGet, NULL, FALSE, keys, values)},
      // Map#has(key:void*):boolean
      has:      {value: bind.call(sharedHas, NULL, FALSE, keys, values)},
      // Map#set(key:void*, value:void*):void
      set:      {value: bind.call(sharedSet, NULL, FALSE, keys, values)}
      /*,
      // Map#size(void):number === Mozilla only so far
      size:     {value: bind.call(sharedSize, NULL, keys)},
      // Map#keys(void):Array === not in specs
      keys:     {value: boundSlice(keys)},
      // Map#values(void):Array === not in specs
      values:   {value: boundSlice(values)},
      // Map#iterate(callback:Function, context:void*):void ==> callback.call(context, key, value, index) === not in specs
      iterate:  {value: bind.call(sharedIterate, NULL, FALSE, keys, values)}
      //*/
    });

  }

  // Set(void):Set
  /**
   * to be really honest, I would rather pollute Array.prototype
   * in order to have Set like behavior
   * Object.defineProperties(Array.prototype, {
   *   add: {value: function add(value) {
   *     return -1 < this.indexOf(value) && !!this.push(value);
   *   }}
   *   has: {value: function has(value) {
   *     return -1 < this.indexOf(value);
   *   }}
   *   delete: {value: function delete(value) {
   *     var i = this.indexOf(value);
   *     return -1 < i && !!this.splice(i, 1);
   *   }}
   * });
   * ... anyway ...
   */
  function Set() {
    var
      keys = [],  // placeholder used simply to recycle functions
      values = [],// real storage
      has = bind.call(sharedHas, NULL, FALSE, values, keys)
    ;
    return create(SetPrototype, {
      // Set#delete(value:void*):boolean
      "delete": {value: bind.call(sharedDel, NULL, FALSE, values, keys)},
      // Set#has(value:void*):boolean
      has:      {value: has},
      // Set#add(value:void*):boolean
      add:      {value: bind.call(Set_add, NULL, FALSE, has, values)}
      /*,
      // Map#size(void):number === Mozilla only
      size:     {value: bind.call(sharedSize, NULL, values)},
      // Set#values(void):Array === not in specs
      values:   {value: boundSlice(values)},
      // Set#iterate(callback:Function, context:void*):void ==> callback.call(context, value, index) === not in specs
      iterate:  {value: bind.call(Set_iterate, NULL, FALSE, NULL, values)}
      //*/
    });
  }

  // common shared method recycled for all shims through bind
  function sharedDel(objectOnly, keys, values, key) {
    if (sharedHas(objectOnly, keys, values, key)) {
      keys.splice(i, 1);
      values.splice(i, 1);
    }
    // Aurora here does it while Canary doesn't
    return -1 < i;
  }

  function sharedGet(objectOnly, keys, values, key/*, d3fault*/) {
    return sharedHas(objectOnly, keys, values, key) ? values[i] : undefined; //d3fault;
  }

  function sharedHas(objectOnly, keys, values, key) {
    if (objectOnly && key !== Object(key))
      throw new TypeError("not a non-null object")
    ;
    i = betterIndexOf.call(keys, key);
    return -1 < i;
  }

  function sharedSet(objectOnly, keys, values, key, value) {
    /* return */sharedHas(objectOnly, keys, values, key) ?
      values[i] = value
      :
      values[keys.push(key) - 1] = value
    ;
  }

  /* keys, values, and iterate related methods
  function boundSlice(values) {
    return function () {
      return slice.call(values);
    };
  }

  function sharedSize(keys) {
    return keys.length;
  }

  function sharedIterate(objectOnly, keys, values, callback, context) {
    for (var
      k = slice.call(keys), v = slice.call(values),
      i = 0, length = k.length;
      i < length; callback.call(context, k[i], v[i], i++)
    );
  }

  function Set_iterate(objectOnly, keys, values, callback, context) {
    for (var
      v = slice.call(values),
      i = 0, length = v.length;
      i < length; callback.call(context, v[i], i++)
    );
  }
  //*/

  // Set#add recycled through bind per each instanceof Set
  function Set_add(objectOnly, has, values, value) {
    /*return */(!has(value) && !!values.push(value));
  }

  // a more reliable indexOf
  function betterIndexOf(value) {
    if (value != value || value === 0) {
      for (i = this.length; i-- && !is(this[i], value););
    } else {
      i = indexOf.call(this, value);
    }
    return i;
  }

  // need for an empty constructor ...
  function Constructor(){}  // GC'ed if !!Object.create
  // ... so that new WeakMapInstance and new WeakMap
  // produces both an instanceof WeakMap

  var
    // shortcuts and ...
    NULL = null, TRUE = true, FALSE = false,
    notInNode = module == "undefined",
    window = notInNode ? this : global,
    module = notInNode ? {} : exports,
    Object = window.Object,
    WeakMapPrototype = WeakMap.prototype,
    MapPrototype = Map.prototype,
    SetPrototype = Set.prototype,
    defineProperty = Object.defineProperty,
    slice = [].slice,

    // Object.is(a, b) shim
    is = Object.is || function (a, b) {
      return a === b ?
        a !== 0 || 1 / a == 1 / b :
        a != a && b != b
      ;
    },

    // partial polyfill for this aim only
    bind = WeakMap.bind || function bind(context, objectOnly, keys, values) {
      // partial fast ad-hoc Function#bind polyfill if not available
      var callback = this;
      return function bound(key, value) {
        return callback.call(context, objectOnly, keys, values, key, value);
      };
    },

    create = Object.create || function create(proto, descriptor) {
      // partial ad-hoc Object.create shim if not available
      Constructor.prototype = proto;
      var object = new Constructor, key;
      for (key in descriptor) {
        object[key] = descriptor[key].value;
      }
      return object;
    },

    indexOf = [].indexOf || function indexOf(value) {
      // partial fast Array#indexOf polyfill if not available
      for (i = this.length; i-- && this[i] !== value;);
      return i;
    },

    undefined,
    i // recycle ALL the variables !
  ;

  // ~indexOf.call([NaN], NaN) as future possible feature detection

  // used to follow FF behavior where WeakMap.prototype is a WeakMap itself
  WeakMap.prototype = WeakMapPrototype = WeakMap();
  Map.prototype = MapPrototype = Map();
  Set.prototype = SetPrototype = Set();

  // assign it to the global context
  // if already there, e.g. in node, export native
  window.WeakMap = module.WeakMap = window.WeakMap || WeakMap;
  window.Map = module.Map = window.Map || Map;
  window.Set = module.Set = window.Set || Set;

  /* probably not needed, add a slash to ensure non configurable and non writable
  if (defineProperty) {
    defineProperty(window, "WeakMap", {value: WeakMap});
    defineProperty(window, "Map", {value: Map});
    defineProperty(window, "Set", {value: Set});
  }
  //*/

  // that's pretty much it

}.call(
  this,
  typeof exports
));