module.exports = function(command, done) {
  var sweet = require('sweet.js');
                  var file = require('file');
                  var fs = require('fs');
                  var path = require('path');
                  
                  var jsFiles = [];
                  file.walkSync(command.indir, function(dir, dirs, files) {
                    files.forEach(function(f) {
                      if (/.*\.js$/.test(f)) {
                        jsFiles.push(path.join(dir, f));
                      }
                    });
                  });
                  jsFiles.forEach(function(f) {
                    jsFiles = jsFiles.slice(1);
                    var data = sweet.compile(fs.readFileSync(f, 'utf8'));
                    var target = path.join(command.outdir, path.relative(command.indir, f));
                    fs.writeFile(target, data, function() {
                      if (jsFiles.length == 0) done();
                    });
                  });
}
