module.exports = function(command, done) {
  var SVGO = require('svgo');
                  var file = require('file');
                  var fs = require('fs');
                  var path = require('path');
                  
                  var svgFiles = [];
                  file.walkSync(command.indir, function(dir, dirs, files) {
                    files.forEach(function(f) {
                      if (/.*\.svg$/.test(f)) {
                        svgFiles.push(path.join(dir, f));
                      }
                    });
                  });
                  svgFiles.forEach(function(f) {
                    svgFiles = svgFiles.slice(1);
                    new SVGO().optimize(fs.readFileSync(f, {encoding:'utf8'}), function(result) {
                      var target = path.join(command.outdir, path.relative(command.indir, f));
                      fs.writeFileSync(target, result.data);
                      if (svgFiles.length == 0) done();
                    });
                  });
}
