CSSO (CSS Optimizer) является минимизатором CSS, выполняющим как минимизацию без изменения структуры, так и структурную минимизацию с целью получить как можно меньший текст.

# Минимизация (кратко)

Минимизация без изменения структуры:

* Удаление whitespace
* Удаление концевых `;`
* Удаление комментариев
* Удаление неправильных `@charset` и `@import`
* Минимизация цвета
* Минимизация `0`
* Слияние многострочных строк в однострочные
* Минимизация `font-weight`

Минимизация с изменением структуры:

* Слияние блоков с одинаковыми селекторами
* Слияние блоков с одинаковыми свойствами
* Удаление перекрываемых свойств
* Удаление перекрываемых shorthand-свойств
* Удаление повторяющихся селекторов
* Частичное слияние блоков
* Частичное разделение блоков
* Удаление пустых ruleset и at-rule
* Минимизация `margin` и `padding`

Подробнее смотри в [детальном описании](/tools/csso/description/) минимизации.

# Авторы

* идея и поддержка&nbsp;— Виталий Харисов (<vitaly@harisov.name>)
* реализация&nbsp;— Сергей Крыжановский (<skryzhanovsky@ya.ru>)
* перевод на английский язык&nbsp;— Leonid Khachaturov (<leonidkhachaturov@gmail.com>)

# Обратная связь

Замеченные ошибки лучше добавлять в [Issues](https://github.com/css/csso/issues) проекта.

Советы, предложения, отзывы, а также ошибки, которые почему-то лучше выслать письмом, высылайте на адрес <skryzhanovsky@ya.ru>.

# Лицензия

* CSSO распространяется под [лицензией MIT](https://github.com/css/csso/blob/master/MIT-LICENSE.txt)

