try {
    // Old IE browsers that do not curry arguments
    if (!setTimeout.call) {
        var slicer = Array.prototype.slice;
        exports.setTimeout = function(fn) {
            var args = slicer.call(arguments, 1);
            return setTimeout(function() {
                return fn.apply(this, args);
            })
        };

        exports.setInterval = function(fn) {
            var args = slicer.call(arguments, 1);
            return setInterval(function() {
                return fn.apply(this, args);
            });
        };
    } else {
        exports.setTimeout = setTimeout;
        exports.setInterval = setInterval;
    }
    exports.clearTimeout = clearTimeout;
    exports.clearInterval = clearInterval;

    if (window.setImmediate) {
      exports.setImmediate = window.setImmediate;
      exports.clearImmediate = window.clearImmediate;
    }

    // Chrome and PhantomJS seems to depend on `this` pseudo variable being a
    // `window` and throws invalid invocation exception otherwise. If this code
    // runs in such JS runtime next line will throw and `catch` clause will
    // exported timers functions bound to a window.
    exports.setTimeout(function() {});
} catch (_) {
    function bind(f, context) {
        return function () { return f.apply(context, arguments) };
    }

    if (typeof window !== 'undefined') {
      exports.setTimeout = bind(setTimeout, window);
      exports.setInterval = bind(setInterval, window);
      exports.clearTimeout = bind(clearTimeout, window);
      exports.clearInterval = bind(clearInterval, window);
      if (window.setImmediate) {
        exports.setImmediate = bind(window.setImmediate, window);
        exports.clearImmediate = bind(window.clearImmediate, window);
      }
    } else {
      if (typeof setTimeout !== 'undefined') {
        exports.setTimeout = setTimeout;
      }
      if (typeof setInterval !== 'undefined') {
        exports.setInterval = setInterval;
      }
      if (typeof clearTimeout !== 'undefined') {
        exports.clearTimeout = clearTimeout;
      }
      if (typeof clearInterval === 'function') {
        exports.clearInterval = clearInterval;
      }
    }
}

exports.unref = function unref() {};
exports.ref = function ref() {};

if (!exports.setImmediate) {
  var currentKey = 0, queue = {}, active = false;

  exports.setImmediate = (function () {
      function drain() {
        active = false;
        for (var key in queue) {
          if (queue.hasOwnProperty(currentKey, key)) {
            var fn = queue[key];
            delete queue[key];
            fn();
          }
        }
      }

      if (typeof window !== 'undefined' &&
          window.postMessage && window.addEventListener) {
        window.addEventListener('message', function (ev) {
          if (ev.source === window && ev.data === 'browserify-tick') {
            ev.stopPropagation();
            drain();
          }
        }, true);

        return function setImmediate(fn) {
          var id = ++currentKey;
          queue[id] = fn;
          if (!active) {
            active = true;
            window.postMessage('browserify-tick', '*');
          }
          return id;
        };
      } else {
        return function setImmediate(fn) {
          var id = ++currentKey;
          queue[id] = fn;
          if (!active) {
            active = true;
            setTimeout(drain, 0);
          }
          return id;
        };
      }
  })();

  exports.clearImmediate = function clearImmediate(id) {
    delete queue[id];
  };
}
