/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.osgi.telnetd;

import de.matrixweb.osgi.kernel.maven.Installer;
import de.matrixweb.osgi.telnetd.CommandException;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.net.Socket;
import org.osgi.util.tracker.ServiceTracker;

public class CommandListener
extends Thread {
    private final ServiceTracker<Installer, Installer> maven;

    public CommandListener(ServiceTracker<Installer, Installer> maven) {
        this.maven = maven;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        ServerSocket server = null;
        try {
            try {
                server = new ServerSocket(1149);
                server.setReuseAddress(true);
                while (true) {
                    this.handleClient(server.accept());
                }
            }
            catch (IOException e) {
                throw new CommandException(e);
            }
        }
        catch (Throwable throwable) {
            if (server != null) {
                try {
                    server.close();
                }
                catch (IOException e) {
                    throw new CommandException(e);
                }
            }
            throw throwable;
        }
    }

    private void handleClient(Socket client) {
        block7: {
            try {
                BufferedInputStream in = null;
                try {
                    in = new BufferedInputStream(client.getInputStream());
                    Installer installer = (Installer)this.maven.getService();
                    if (installer != null) {
                        installer.installOrUpdate(this.readCommand(in).trim());
                        break block7;
                    }
                    throw new CommandException("No maven installer service available", null);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                    client.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private String readCommand(InputStream in) throws IOException {
        StringBuilder buf = new StringBuilder();
        char c = (char)in.read();
        while (c != '\n') {
            buf.append(c);
            c = (char)in.read();
        }
        return buf.toString();
    }
}

