/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.maven.plugins.relocator;

import de.matrixweb.maven.plugins.relocator.Relocator;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.SelectorUtils;

public class SimpleRelocator
implements Relocator {
    private final String pattern;
    private final String pathPattern;
    private final String shadedPattern;
    private final String shadedPathPattern;
    private final Set<String> includes;
    private final Set<String> excludes;

    public SimpleRelocator(String patt, String shadedPattern, List<String> includes, List<String> excludes) {
        if (patt == null) {
            this.pattern = "";
            this.pathPattern = "";
        } else {
            this.pattern = patt.replace('/', '.');
            this.pathPattern = patt.replace('.', '/');
        }
        if (shadedPattern != null) {
            this.shadedPattern = shadedPattern.replace('/', '.');
            this.shadedPathPattern = shadedPattern.replace('.', '/');
        } else {
            this.shadedPattern = "hidden." + this.pattern;
            this.shadedPathPattern = "hidden/" + this.pathPattern;
        }
        this.includes = SimpleRelocator.normalizePatterns(includes);
        this.excludes = SimpleRelocator.normalizePatterns(excludes);
    }

    private static Set<String> normalizePatterns(Collection<String> patterns) {
        LinkedHashSet<String> normalized = null;
        if (patterns != null && !patterns.isEmpty()) {
            normalized = new LinkedHashSet<String>();
            for (String pattern : patterns) {
                String classPattern = pattern.replace('.', '/');
                normalized.add(classPattern);
                if (!classPattern.endsWith("/*")) continue;
                String packagePattern = classPattern.substring(0, classPattern.lastIndexOf(47));
                normalized.add(packagePattern);
            }
        }
        return normalized;
    }

    private boolean isIncluded(String path) {
        if (this.includes != null && !this.includes.isEmpty()) {
            for (String include : this.includes) {
                if (!SelectorUtils.matchPath((String)include, (String)path, (boolean)true)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isExcluded(String path) {
        if (this.excludes != null && !this.excludes.isEmpty()) {
            for (String exclude : this.excludes) {
                if (!SelectorUtils.matchPath((String)exclude, (String)path, (boolean)true)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canRelocatePath(String path) {
        if (path.endsWith(".class")) {
            path = path.substring(0, path.length() - 6);
        }
        if (!this.isIncluded(path) || this.isExcluded(path)) {
            return false;
        }
        return path.startsWith(this.pathPattern) || path.startsWith("/" + this.pathPattern);
    }

    @Override
    public boolean canRelocateClass(String clazz) {
        return clazz.indexOf(47) < 0 && this.canRelocatePath(clazz.replace('.', '/'));
    }

    @Override
    public String relocatePath(String path) {
        return path.replaceFirst(this.pathPattern, this.shadedPathPattern);
    }

    @Override
    public String relocateClass(String clazz) {
        return clazz.replaceFirst(this.pattern, this.shadedPattern);
    }

    @Override
    public String applyToSourceContent(String sourceContent) {
        return sourceContent.replaceAll("\\b" + this.pattern, this.shadedPattern);
    }
}

