/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.maven.plugins.relocator;

import de.matrixweb.maven.plugins.relocator.PackageRelocation;
import de.matrixweb.maven.plugins.relocator.Relocator;
import de.matrixweb.maven.plugins.relocator.SimpleRelocator;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;

@Mojo(name="relocate", defaultPhase=LifecyclePhase.PACKAGE)
public class RelocatorMojo
extends AbstractMojo {
    @Component
    private MavenProject project;
    @Parameter
    private PackageRelocation[] relocations;
    @Parameter(defaultValue="${project.build.directory}")
    private File outputDirectory;

    public void execute() throws MojoExecutionException, MojoFailureException {
        Artifact artifact = this.project.getArtifact();
        File target = new File(this.outputDirectory, artifact.getArtifactId() + "-" + artifact.getVersion() + "." + artifact.getArtifactHandler().getExtension());
        this.getLog().info((CharSequence)("Relocating inside " + target));
        try {
            this.doRelocation(target);
        }
        catch (IOException e) {
            throw new MojoFailureException("Failed to relocate classes/resources inside jar", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRelocation(File target) throws IOException, MojoExecutionException {
        File temp = File.createTempFile("relocation-", ".jar");
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(temp);
            JarOutputStream jos = new JarOutputStream(new BufferedOutputStream(fileOutputStream));
            HashSet<String> resources = new HashSet<String>();
            List<Relocator> relocators = this.getRelocators();
            RelocatorRemapper remapper = new RelocatorRemapper(relocators);
            JarFile jarFile = new JarFile(target);
            Enumeration<JarEntry> j = jarFile.entries();
            while (j.hasMoreElements()) {
                String dir;
                JarEntry entry = j.nextElement();
                String name = entry.getName();
                if (entry.isDirectory()) continue;
                String mappedName = remapper.map(name);
                this.getLog().debug((CharSequence)("Remapping " + name + " to " + mappedName));
                InputStream is = jarFile.getInputStream(entry);
                int idx = mappedName.lastIndexOf(47);
                if (idx != -1 && !resources.contains(dir = mappedName.substring(0, idx))) {
                    this.addDirectory(resources, jos, dir);
                }
                if (name.endsWith(".class")) {
                    this.addRemappedClass(remapper, jos, target, name, is);
                } else {
                    if (resources.contains(mappedName)) continue;
                    this.addResource(resources, jos, mappedName, is);
                }
                IOUtil.close((InputStream)is);
            }
            jarFile.close();
            IOUtil.close((OutputStream)jos);
            FileUtils.copyFile((File)temp, (File)target);
        }
        finally {
            temp.delete();
        }
    }

    private List<Relocator> getRelocators() {
        ArrayList<Relocator> relocators = new ArrayList<Relocator>();
        if (this.relocations == null) {
            return relocators;
        }
        for (PackageRelocation r : this.relocations) {
            relocators.add(new SimpleRelocator(r.getPattern(), r.getShadedPattern(), r.getIncludes(), r.getExcludes()));
        }
        return relocators;
    }

    private void addDirectory(Set<String> resources, JarOutputStream jos, String name) throws IOException {
        String parent;
        if (name.lastIndexOf(47) > 0 && !resources.contains(parent = name.substring(0, name.lastIndexOf(47)))) {
            this.addDirectory(resources, jos, parent);
        }
        JarEntry entry = new JarEntry(name + "/");
        jos.putNextEntry(entry);
        resources.add(name);
    }

    private void addRemappedClass(RelocatorRemapper remapper, JarOutputStream jos, File jar, String name, InputStream is) throws IOException, MojoExecutionException {
        if (!remapper.hasRelocators()) {
            try {
                jos.putNextEntry(new JarEntry(name));
                IOUtil.copy((InputStream)is, (OutputStream)jos);
            }
            catch (ZipException e) {
                this.getLog().debug((CharSequence)("We have a duplicate " + name + " in " + jar));
            }
            return;
        }
        ClassReader cr = new ClassReader(is);
        ClassWriter cw = new ClassWriter(0);
        RemappingClassAdapter cv = new RemappingClassAdapter((ClassVisitor)cw, (Remapper)remapper);
        try {
            cr.accept((ClassVisitor)cv, 8);
        }
        catch (Throwable ise) {
            throw new MojoExecutionException("Error in ASM processing class " + name, ise);
        }
        byte[] renamedClass = cw.toByteArray();
        String mappedName = remapper.map(name.substring(0, name.indexOf(46)));
        try {
            jos.putNextEntry(new JarEntry(mappedName + ".class"));
            IOUtil.copy((byte[])renamedClass, (OutputStream)jos);
        }
        catch (ZipException e) {
            this.getLog().debug((CharSequence)("We have a duplicate " + mappedName + " in " + jar));
        }
    }

    private void addResource(Set<String> resources, JarOutputStream jos, String name, InputStream is) throws IOException {
        jos.putNextEntry(new JarEntry(name));
        IOUtil.copy((InputStream)is, (OutputStream)jos);
        resources.add(name);
    }

    class RelocatorRemapper
    extends Remapper {
        private final Pattern classPattern = Pattern.compile("(\\[*)?L(.+);");
        List<Relocator> relocators;

        public RelocatorRemapper(List<Relocator> relocators) {
            this.relocators = relocators;
        }

        public boolean hasRelocators() {
            return !this.relocators.isEmpty();
        }

        public Object mapValue(Object object) {
            if (object instanceof String) {
                String name;
                String value = name = (String)object;
                String prefix = "";
                String suffix = "";
                Matcher m = this.classPattern.matcher(name);
                if (m.matches()) {
                    prefix = m.group(1) + "L";
                    suffix = ";";
                    name = m.group(2);
                }
                for (Relocator r : this.relocators) {
                    if (r.canRelocateClass(name)) {
                        value = prefix + r.relocateClass(name) + suffix;
                        break;
                    }
                    if (!r.canRelocatePath(name)) continue;
                    value = prefix + r.relocatePath(name) + suffix;
                    break;
                }
                return value;
            }
            return super.mapValue(object);
        }

        public String map(String name) {
            String value = name;
            String prefix = "";
            String suffix = "";
            Matcher m = this.classPattern.matcher(name);
            if (m.matches()) {
                prefix = m.group(1) + "L";
                suffix = ";";
                name = m.group(2);
            }
            for (Relocator r : this.relocators) {
                if (!r.canRelocatePath(name)) continue;
                value = prefix + r.relocatePath(name) + suffix;
                break;
            }
            return value;
        }
    }
}

