/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.jreact;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.matrixweb.jreact.ClasspathBasedFilesystem;
import de.matrixweb.jreact.FilebasedFilesystem;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

public class JReact {
    private final ScriptEngine js;
    private String componentCode;
    private boolean harmony = false;
    private boolean sourceMaps = false;

    public JReact() {
        this(new ScriptEngineManager().getEngineByMimeType("application/javascript"));
    }

    public JReact(boolean useClasspathResources) {
        this(new ScriptEngineManager().getEngineByMimeType("application/javascript"), useClasspathResources);
    }

    public JReact(ScriptEngine js) {
        this(js, false);
    }

    public JReact(ScriptEngine js, boolean useClasspathResources) {
        this.js = js;
        if (useClasspathResources) {
            js.put("filesystem", new ClasspathBasedFilesystem());
        } else {
            js.put("filesystem", new FilebasedFilesystem());
        }
        try {
            this.js.eval(new InputStreamReader(this.getClass().getResourceAsStream("/require.js"), "UTF-8"));
            this.js.eval("if (typeof process === 'undefined') { process = { env: {} }; }");
            this.js.eval("if (typeof console === 'undefined') { console = { log: function(s) { print(s + '\\n'); }, warn: function(s) { print(s + '\\n'); } }; }");
        }
        catch (UnsupportedEncodingException | ScriptException e) {
            throw new RuntimeException("Failed to setup JavaScriptEngine", e);
        }
    }

    public void setHarmony(boolean harmony) {
        this.harmony = harmony;
    }

    public void setSourceMaps(boolean sourceMaps) {
        this.sourceMaps = sourceMaps;
    }

    public JReact addRequirePath(String path) {
        try {
            this.js.eval("require.paths.push('" + path + "');");
        }
        catch (ScriptException e) {
            throw new RuntimeException("Failed to setup JavaScriptEngine", e);
        }
        return this;
    }

    public String renderComponentToString(String mainComponentPath, Map<String, Object> props) throws IOException {
        return this.render(mainComponentPath, props, false);
    }

    public String renderComponentToStaticMarkup(String mainComponentPath, Map<String, Object> props) throws IOException {
        return this.render(mainComponentPath, props, true);
    }

    public String renderToString(String mainComponentPath, Map<String, Object> props) throws IOException {
        return this.render(mainComponentPath, props, false);
    }

    public String renderToStaticMarkup(String mainComponentPath, Map<String, Object> props) throws IOException {
        return this.render(mainComponentPath, props, true);
    }

    private String render(String mainComponentPath, Map<String, Object> props, boolean staticMarkup) throws IOException {
        try {
            if (this.componentCode == null) {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream("/jreact.js"), "UTF-8"));
                StringBuilder sb = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    sb.append(line).append('\n');
                    line = reader.readLine();
                }
                this.componentCode = sb.toString().replace("@@staticMarkup@@", Boolean.toString(staticMarkup)).replace("@@harmony@@", Boolean.toString(this.harmony)).replace("@@sourceMaps@@", Boolean.toString(this.sourceMaps)).replace("@@mainComponentPath@@", mainComponentPath).replace("@@props@@", new ObjectMapper().writeValueAsString(props));
            }
            return (String)this.js.eval(this.componentCode);
        }
        catch (ScriptException e) {
            throw new RuntimeException("Failed to execute render request", e);
        }
    }

    public void reset() {
        this.componentCode = null;
    }
}

