/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.jreact;

import de.matrixweb.jreact.Filesystem;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Scanner;

public class FilebasedFilesystem
implements Filesystem {
    private final String fileBase;

    public FilebasedFilesystem() {
        this(".");
    }

    public FilebasedFilesystem(String fileBase) {
        this.fileBase = fileBase;
    }

    @Override
    public boolean isFile(String fileName) {
        return new File(this.fileBase, fileName.toString()).isFile();
    }

    @Override
    public String readFile(String path) throws FileNotFoundException {
        try (Scanner scanner = new Scanner(new File(this.fileBase, path), "UTF-8");){
            String string = scanner.useDelimiter("\\Z").next().toString();
            return string;
        }
    }

    @Override
    public String getDirectory(String path) throws FileNotFoundException {
        File dir = new File(this.fileBase, path);
        return dir.isDirectory() ? dir.getName() : dir.getParent();
    }

    @Override
    public String getFilename(String path) throws FileNotFoundException {
        return new File(this.fileBase, path).getName();
    }

    @Override
    public boolean exists(String fileName) {
        return new File(fileName).exists();
    }
}

