/*
 * Decompiled with CFR 0.152.
 */
package de.matrixweb.jreact;

import de.matrixweb.jreact.Filesystem;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;

public class ClasspathBasedFilesystem
implements Filesystem {
    private final ClassLoader loader;

    public ClasspathBasedFilesystem() {
        this.loader = this.getClass().getClassLoader();
    }

    public ClasspathBasedFilesystem(ClassLoader loader) {
        this.loader = loader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isFile(String fileName) {
        URL url = this.loader.getResource(fileName);
        if (url == null) {
            return false;
        }
        String[] strings = url.getPath().split("/");
        String last = strings[strings.length - 1];
        if (!last.contains(".")) return false;
        try (InputStream in = this.loader.getResourceAsStream(fileName);){
            boolean bl = in != null;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public String readFile(String path) throws IOException {
        try (InputStream in = this.loader.getResourceAsStream(path);){
            String string = new Scanner(in, "UTF-8").useDelimiter("\\Z").next().toString();
            return string;
        }
    }

    @Override
    public String getDirectory(String path) throws FileNotFoundException {
        URL url = this.loader.getResource(path);
        String[] strings = url.getPath().split("/");
        String last = strings[strings.length - 1];
        if (last.contains(".")) {
            return strings[strings.length - 2];
        }
        return last;
    }

    @Override
    public String getFilename(String path) throws FileNotFoundException {
        URL url = this.loader.getResource(path);
        String[] strings = url.getPath().split("/");
        return strings[strings.length - 1];
    }

    @Override
    public boolean exists(String fileName) {
        return this.loader.getResource(fileName) != null;
    }
}

