/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.commons.boot;

import br.com.softplan.security.zap.commons.ZapInfo;
import br.com.softplan.security.zap.commons.boot.AbstractZapBoot;
import br.com.softplan.security.zap.commons.exception.ZapInitializationException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZapLocalBoot
extends AbstractZapBoot {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZapLocalBoot.class);
    private static Process zap;

    @Override
    public void startZap(ZapInfo zapInfo) {
        int port = zapInfo.getPort();
        if (ZapLocalBoot.isZapRunning(port)) {
            LOGGER.info("ZAP is already up and running! No attempts will be made to start ZAP.");
            return;
        }
        try {
            ZapLocalBoot.start(zapInfo);
            ZapLocalBoot.waitForZapInitialization(port, zapInfo.getInitializationTimeoutInMillis());
        }
        catch (IOException e) {
            LOGGER.error("Error starting ZAP.", (Throwable)e);
        }
    }

    @Override
    public void stopZap() {
        if (zap != null) {
            LOGGER.info("Stopping ZAP.");
            zap.destroy();
        }
    }

    private static void start(ZapInfo zapInfo) throws IOException {
        String startCommand = ZapLocalBoot.buildStartCommand(zapInfo);
        ProcessBuilder processBuilder = new ProcessBuilder(startCommand.split(" +"));
        processBuilder.directory(ZapLocalBoot.getZapWorkingDirectory(zapInfo));
        Files.createDirectories(Paths.get(DEFAULT_ZAP_LOG_PATH, new String[0]), new FileAttribute[0]);
        processBuilder.redirectOutput(new File(DEFAULT_ZAP_LOG_PATH, "zap.log"));
        LOGGER.info("Starting ZAP with command: {}", (Object)startCommand);
        zap = processBuilder.start();
    }

    private static String buildStartCommand(ZapInfo zapInfo) {
        StringBuilder startCommand = new StringBuilder();
        startCommand.append("java").append(" ");
        startCommand.append(zapInfo.getJmvOptions()).append(" ");
        startCommand.append("-jar").append(" ");
        try {
            String zapJarName = ZapLocalBoot.retrieveZapJarName(zapInfo.getPath());
            startCommand.append(zapJarName).append(" ");
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving ZAP's JAR file.");
        }
        String options = zapInfo.getOptions();
        startCommand.append(options != null ? options : "-daemon -config api.disablekey=true -config api.incerrordetails=true -config proxy.ip=0.0.0.0");
        startCommand.append(" -port ").append(zapInfo.getPort());
        return startCommand.toString();
    }

    private static String retrieveZapJarName(String path) throws IOException {
        Path zapPath = Paths.get(path, new String[0]);
        if (ZapLocalBoot.isJarFile(zapPath)) {
            String filename = zapPath.getFileName().toString();
            LOGGER.debug("ZapPath points to the Jar file {}", (Object)filename);
            return filename;
        }
        LOGGER.debug("ZapPath points to the folder {}", (Object)zapPath.getFileName().toString());
        for (Path p : Files.newDirectoryStream(zapPath)) {
            if (!ZapLocalBoot.isJarFile(p)) continue;
            String filename = p.getFileName().toString();
            LOGGER.debug("Chosen Zap Jar file {}", (Object)filename);
            return filename;
        }
        throw new ZapInitializationException("ZAP's JAR file was not found.");
    }

    private static boolean isJarFile(Path path) {
        if (path == null) {
            return false;
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            return false;
        }
        Path fileName = path.getFileName();
        if (fileName == null) {
            return false;
        }
        return fileName.toString().endsWith(".jar");
    }

    private static File getZapWorkingDirectory(ZapInfo zapInfo) {
        String fullPath = zapInfo.getPath();
        File dir = new File(fullPath);
        if (dir.isDirectory()) {
            return dir;
        }
        if (dir.isFile()) {
            return dir.getParentFile();
        }
        return new File(System.getProperty("user.dir"));
    }
}

