/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.commons.boot;

import br.com.softplan.security.zap.commons.ZapInfo;
import br.com.softplan.security.zap.commons.boot.AbstractZapBoot;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZapDockerBoot
extends AbstractZapBoot {
    private static final Logger LOGGER = LoggerFactory.getLogger(ZapDockerBoot.class);
    private static final String DEFAULT_DOCKER_COMMAND = "docker run --rm";
    private static final String ZAP_IMAGE_OPTION = " -i owasp/zap2docker-stable zap.sh ";
    public static final String CAS_AUTH_SCRIPT_DEFAULT_DOCKER_PATH = "/zap/scripts/";
    private static final String CAS_AUTH_SCRIPT_FILE_NAME = "cas-auth.js";
    private static Process zap;

    @Override
    public void startZap(ZapInfo zapInfo) {
        int port = zapInfo.getPort();
        if (ZapDockerBoot.isZapRunning(port)) {
            LOGGER.info("ZAP is already up and running! No attempts will be made to start ZAP.");
            return;
        }
        try {
            ZapDockerBoot.copyCasAuthScriptFileToMappedFolder();
            ZapDockerBoot.startZap(zapInfo.getPath(), ZapDockerBoot.buildStartCommand(zapInfo));
            ZapDockerBoot.waitForZapInitialization(port, zapInfo.getInitializationTimeoutInMillis());
        }
        catch (IOException e) {
            LOGGER.error("Error starting ZAP.", (Throwable)e);
        }
    }

    private static void copyCasAuthScriptFileToMappedFolder() {
        new File(CAS_AUTH_SCRIPT_DEFAULT_DOCKER_PATH).mkdirs();
        File scriptFile = new File(CAS_AUTH_SCRIPT_DEFAULT_DOCKER_PATH, CAS_AUTH_SCRIPT_FILE_NAME);
        InputStream casAuthScriptInputStream = ZapDockerBoot.class.getResourceAsStream("/scripts/cas-auth.js");
        try (FileOutputStream fileOutputStream = new FileOutputStream(scriptFile);){
            IOUtils.copy((InputStream)casAuthScriptInputStream, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            LOGGER.error("Error while trying to create the script file for CAS authentication in /zap/scripts/. The analysis will continue but CAS authentication will work only if the script file can be accessed by ZAP's Docker image (a default volume is created in /zap/scripts/).", (Throwable)e);
        }
    }

    @Override
    public void stopZap() {
        if (zap != null) {
            LOGGER.info("Stopping ZAP.");
            zap.destroy();
        }
    }

    private static String buildStartCommand(ZapInfo zapInfo) {
        StringBuilder startCommand = new StringBuilder(DEFAULT_DOCKER_COMMAND);
        ZapDockerBoot.appendVolumeOption(startCommand);
        ZapDockerBoot.appendPortOption(zapInfo, startCommand);
        startCommand.append(ZAP_IMAGE_OPTION);
        String options = zapInfo.getOptions();
        startCommand.append(options != null ? options : "-daemon -config api.disablekey=true -config api.incerrordetails=true -config proxy.ip=0.0.0.0");
        startCommand.append(" -port ").append(zapInfo.getPort());
        return startCommand.toString();
    }

    private static void appendVolumeOption(StringBuilder startCommand) {
        startCommand.append(" -v ");
        startCommand.append(CAS_AUTH_SCRIPT_DEFAULT_DOCKER_PATH);
        startCommand.append(":");
        startCommand.append(CAS_AUTH_SCRIPT_DEFAULT_DOCKER_PATH);
        startCommand.append(":ro");
    }

    private static void appendPortOption(ZapInfo zapInfo, StringBuilder startCommand) {
        startCommand.append(" -p ");
        startCommand.append(zapInfo.getPort());
        startCommand.append(":");
        startCommand.append(zapInfo.getPort());
    }

    private static void startZap(String path, String startCommand) throws IOException {
        ProcessBuilder processBuilder = new ProcessBuilder(startCommand.split(" +"));
        Files.createDirectories(Paths.get(DEFAULT_ZAP_LOG_PATH, new String[0]), new FileAttribute[0]);
        processBuilder.redirectOutput(new File(DEFAULT_ZAP_LOG_PATH, "zap.log"));
        LOGGER.info("Starting ZAP with command: {}", (Object)startCommand);
        zap = processBuilder.start();
    }
}

