/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.report;

import br.com.softplan.security.zap.api.report.SpiderResultsReportBuilder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;

public class ZapReport {
    private byte[] htmlReport;
    private byte[] xmlReport;
    private List<String> spiderResults;
    private String htmlSpiderResults;
    private String xmlSpiderResults;

    public ZapReport(byte[] htmlReport, byte[] xmlReport, List<String> spiderResults) {
        this.htmlReport = htmlReport;
        this.xmlReport = xmlReport;
        this.spiderResults = spiderResults;
        this.buildSpiderResultsReports(spiderResults);
    }

    private void buildSpiderResultsReports(List<String> spiderResults) {
        this.htmlSpiderResults = SpiderResultsReportBuilder.buildHtmlReport(spiderResults);
        this.xmlSpiderResults = SpiderResultsReportBuilder.buildXmlReport(spiderResults);
    }

    public String getHtmlReportAsString() {
        return new String(this.htmlReport, StandardCharsets.UTF_8);
    }

    public byte[] getHtmlReport() {
        return this.htmlReport;
    }

    public String getXmlReportAsString() {
        return new String(this.xmlReport, StandardCharsets.UTF_8);
    }

    public byte[] getXmlReport() {
        return this.xmlReport;
    }

    public List<String> getSpiderResults() {
        return Collections.unmodifiableList(this.spiderResults);
    }

    public String getHtmlSpiderResultsAsString() {
        return this.htmlSpiderResults;
    }

    public byte[] getHtmlSpiderResults() {
        return this.htmlSpiderResults.getBytes(StandardCharsets.UTF_8);
    }

    public String getXmlSpiderResultsAsString() {
        return this.xmlSpiderResults;
    }

    public byte[] getXmlSpiderResults() {
        return this.xmlSpiderResults.getBytes();
    }
}

