/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.authentication;

import br.com.softplan.security.zap.api.ZapHelper;
import br.com.softplan.security.zap.api.authentication.AuthenticationScript;
import br.com.softplan.security.zap.api.exception.ZapClientException;
import br.com.softplan.security.zap.commons.ZapInfo;
import java.io.IOException;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseList;
import org.zaproxy.clientapi.core.ApiResponseSet;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public class AuthenticationScriptLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthenticationScriptLoader.class);
    private static final String JAVASCRIPT_ENGINE_IDENTIFIER = "ECMAScript";
    private static final String ZAP_SCRIPT_TYPE = "authentication";
    private ClientApi api;
    private String apiKey;
    private final boolean isZapRunningOnDocker;
    private AuthenticationScript script;

    public AuthenticationScriptLoader(ClientApi api, ZapInfo zapInfo, String scriptName, String scriptDescription) {
        this.api = api;
        this.apiKey = zapInfo.getApiKey();
        this.isZapRunningOnDocker = zapInfo.shouldRunWithDocker();
        this.script = new AuthenticationScript(scriptName, scriptDescription);
    }

    public void loadScript() {
        try {
            this.clearPreviouslyLoadedCasAuthScript();
            String scriptEngine = this.pickAvailableJavaScriptEngine();
            String scriptPath = this.script.getPath(this.isZapRunningOnDocker);
            LOGGER.debug("Loading authentication script from file: {}.", (Object)scriptPath);
            ApiResponse response = this.api.script.load(this.apiKey, this.script.getName(), ZAP_SCRIPT_TYPE, scriptEngine, scriptPath, this.script.getDescription());
            ZapHelper.validateResponse(response, "Load authentication script");
        }
        catch (IOException | URISyntaxException | ClientApiException e) {
            LOGGER.error("Error loading authentication script.", e);
            throw new ZapClientException(e);
        }
    }

    private void clearPreviouslyLoadedCasAuthScript() {
        try {
            ApiResponseList listScriptsResponse = (ApiResponseList)this.api.script.listScripts();
            for (ApiResponse currentScript : listScriptsResponse.getItems()) {
                if (!((ApiResponseSet)currentScript).getAttribute("name").equals(this.script.getName())) continue;
                ApiResponse response = this.api.script.remove(this.apiKey, this.script.getName());
                ZapHelper.validateResponse(response, "Clear previously loaded authentication script");
            }
        }
        catch (ClientApiException e) {
            LOGGER.error("Error clearing previously loaded authentication script.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    private String pickAvailableJavaScriptEngine() throws ClientApiException {
        ApiResponseList response = (ApiResponseList)this.api.script.listEngines();
        for (ApiResponse engine : response.getItems()) {
            String engineName = ((ApiResponseElement)engine).getValue();
            if (!this.isJavaScriptEngine(engineName)) continue;
            return engineName;
        }
        throw new ZapClientException("Could not find a JavaScript engine within ZAP.");
    }

    private boolean isJavaScriptEngine(String engineName) {
        return engineName.contains(JAVASCRIPT_ENGINE_IDENTIFIER);
    }
}

