/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.authentication;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URISyntaxException;
import org.apache.commons.io.IOUtils;

public class AuthenticationScript {
    private String name;
    private String description;
    private String fileName;
    private String relativePath;
    private String path;
    private File scriptTempFile;

    public AuthenticationScript(String name, String description) {
        this.name = name;
        this.description = description;
        this.fileName = name + ".js";
        this.relativePath = "/scripts/" + this.fileName;
        this.path = AuthenticationScript.class.getResource(this.relativePath).getPath();
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getRelativePath() {
        return this.relativePath;
    }

    public String getPath(boolean isZapRunningOnDocker) throws IOException, URISyntaxException {
        if (isZapRunningOnDocker) {
            return "/zap/scripts/" + this.fileName;
        }
        if (this.scriptFileIsNotAccessible()) {
            return this.getCasAuthScriptTempFile().getAbsolutePath();
        }
        return this.path;
    }

    private boolean scriptFileIsNotAccessible() throws UnsupportedEncodingException {
        return !new File(this.path).exists();
    }

    private File getCasAuthScriptTempFile() throws IOException {
        if (this.scriptTempFile == null) {
            this.scriptTempFile = this.createCasAuthScriptTempFile();
        }
        return this.scriptTempFile;
    }

    private File createCasAuthScriptTempFile() throws IOException {
        File tempFile = File.createTempFile(this.name, ".js");
        tempFile.deleteOnExit();
        InputStream casAuthScriptInputStream = AuthenticationScript.class.getResourceAsStream(this.relativePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(tempFile);){
            IOUtils.copy((InputStream)casAuthScriptInputStream, (OutputStream)fileOutputStream);
        }
        return tempFile;
    }
}

