/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.authentication;

import br.com.softplan.security.zap.api.ZapHelper;
import br.com.softplan.security.zap.api.authentication.AuthenticationHandler;
import br.com.softplan.security.zap.api.exception.ZapClientException;
import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.commons.ZapInfo;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractAuthenticationHandler.class);
    protected static final String UTF_8 = StandardCharsets.UTF_8.name();
    protected static final String ZAP_DEFAULT_CONTEXT_ID = "1";
    protected static final String ZAP_DEFAULT_SESSION_NAME = "Session 0";
    private ClientApi api;
    private ZapInfo zapInfo;
    private String apiKey;
    private AuthenticationInfo authenticationInfo;
    private String userId;

    protected AbstractAuthenticationHandler(ClientApi api, ZapInfo zapInfo, AuthenticationInfo authenticationInfo) {
        this.api = api;
        this.zapInfo = zapInfo;
        this.apiKey = zapInfo.getApiKey();
        this.authenticationInfo = authenticationInfo;
    }

    protected ClientApi getApi() {
        return this.api;
    }

    protected ZapInfo getZapInfo() {
        return this.zapInfo;
    }

    protected String getApiKey() {
        return this.apiKey;
    }

    protected AuthenticationInfo getAuthenticationInfo() {
        return this.authenticationInfo;
    }

    @Override
    public void handleAuthentication(String targetUrl) {
        LOGGER.debug("--- Starting authentication handling ---");
        this.setupAuthentication(targetUrl);
        this.excludeUrlsFromScanners();
        this.setupLoggedInAndOutRegex();
        LOGGER.debug("--- Finished authentication handling ---\n");
    }

    protected abstract void setupAuthentication(String var1);

    protected void excludeUrlsFromScanners() {
        try {
            String[] excludeFromScan = this.authenticationInfo.getExcludeFromScan();
            if (excludeFromScan != null) {
                for (String url : excludeFromScan) {
                    LOGGER.debug("Excluding URL '{}' from scanners.", (Object)url);
                    ApiResponse responseFromSpider = this.api.spider.excludeFromScan(this.apiKey, "\\Q" + url + "\\E");
                    ZapHelper.validateResponse(responseFromSpider, "Exclude '" + url + "' from Spider.");
                    ApiResponse responseFromAScan = this.api.ascan.excludeFromScan(this.apiKey, "\\Q" + url + "\\E");
                    ZapHelper.validateResponse(responseFromAScan, "Exclude '" + url + "' from Active Scan.");
                }
            }
        }
        catch (ClientApiException e) {
            LOGGER.error("Error excluding URLs from scanners.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    protected void setupLoggedInAndOutRegex() {
        String loggedInRegex = this.authenticationInfo.getLoggedInRegex();
        String loggedOutRegex = this.authenticationInfo.getLoggedOutRegex();
        try {
            ApiResponse response;
            if (loggedInRegex != null) {
                LOGGER.debug("Setting '{}' as the logged in regex.", (Object)loggedInRegex);
                response = this.api.authentication.setLoggedInIndicator(this.apiKey, ZAP_DEFAULT_CONTEXT_ID, loggedInRegex);
                ZapHelper.validateResponse(response, "Set logged in regex");
            }
            if (loggedOutRegex != null) {
                LOGGER.debug("Setting '{}' as the logged out regex.", (Object)loggedOutRegex);
                response = this.api.authentication.setLoggedOutIndicator(this.apiKey, ZAP_DEFAULT_CONTEXT_ID, loggedOutRegex);
                ZapHelper.validateResponse(response, "Set logged out regex");
            }
        }
        catch (ClientApiException e) {
            LOGGER.error("Error setting up logged in and/or logged out regex for authentication.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    protected String createAndEnableUser() {
        LOGGER.debug("Creating and enabling user '{}'.", (Object)this.authenticationInfo.getUsername());
        try {
            ApiResponse responseFromCreating = this.api.users.newUser(this.apiKey, ZAP_DEFAULT_CONTEXT_ID, this.authenticationInfo.getUsername());
            this.userId = ZapHelper.extractResponse(responseFromCreating);
            ApiResponse responseFromEnabling = this.api.users.setUserEnabled(this.apiKey, ZAP_DEFAULT_CONTEXT_ID, this.userId, Boolean.TRUE.toString());
            ZapHelper.validateResponse(responseFromEnabling, "Enable the user");
        }
        catch (ClientApiException e) {
            LOGGER.error("Error creating and enabling user for authentication.", (Throwable)e);
            throw new ZapClientException(e);
        }
        return this.userId;
    }

    protected void setupUserCredentials() {
        LOGGER.debug("Setting up credentials for user '{}'.", (Object)this.authenticationInfo.getUsername());
        try {
            String encodedUsername = URLEncoder.encode(this.authenticationInfo.getUsername(), UTF_8);
            String encodedPassword = URLEncoder.encode(this.authenticationInfo.getPassword(), UTF_8);
            String credentials = "username=" + encodedUsername + "&password=" + encodedPassword;
            ApiResponse responseFromSettingCredentials = this.api.users.setAuthenticationCredentials(this.apiKey, ZAP_DEFAULT_CONTEXT_ID, this.userId, credentials);
            ZapHelper.validateResponse(responseFromSettingCredentials, "Set the user's credentials");
        }
        catch (UnsupportedEncodingException | ClientApiException e) {
            LOGGER.error("Error setting up user's credential for authentication.", e);
            throw new ZapClientException(e);
        }
    }

    protected void enableForcedUserMode() {
        LOGGER.debug("Setting up Forced User Mode.");
        try {
            ApiResponse responseFromSettingForcedUser = this.api.forcedUser.setForcedUser(this.apiKey, ZAP_DEFAULT_CONTEXT_ID, this.userId);
            ZapHelper.validateResponse(responseFromSettingForcedUser, "Set forced user.");
            ApiResponse responseFromEnabling = this.api.forcedUser.setForcedUserModeEnabled(this.apiKey, true);
            ZapHelper.validateResponse(responseFromEnabling, "Enable Forced User Mode.");
        }
        catch (ClientApiException e) {
            LOGGER.error("Error setting up Forced User Mode.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    protected void disableForcedUserMode() {
        LOGGER.debug("Disabling Forced User Mode.");
        try {
            ApiResponse response = this.api.forcedUser.setForcedUserModeEnabled(this.apiKey, false);
            ZapHelper.validateResponse(response, "Disable Forced User Mode.");
        }
        catch (ClientApiException e) {
            LOGGER.error("Error disabling Forced User Mode.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    protected void addHttpSessionTokens(String site) {
        LOGGER.debug("Adding session tokens: {}.", (Object)Arrays.toString(this.authenticationInfo.getHttpSessionTokens()));
        try {
            for (String sessionToken : this.authenticationInfo.getHttpSessionTokens()) {
                ApiResponse response = this.api.httpSessions.addSessionToken(this.apiKey, site, sessionToken);
                ZapHelper.validateResponse(response, "Add session tokens.");
            }
        }
        catch (ClientApiException e) {
            LOGGER.error("Error adding session tokens.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }

    protected void setHttpSessionAsActive(String site) {
        LOGGER.debug("Setting session as active.");
        try {
            ApiResponse response = this.api.httpSessions.setActiveSession(this.apiKey, site, ZAP_DEFAULT_SESSION_NAME);
            ZapHelper.validateResponse(response, "Set session as active.");
        }
        catch (ClientApiException e) {
            LOGGER.error("Error setting session as active.", (Throwable)e);
            throw new ZapClientException(e);
        }
    }
}

