/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api.analysis;

import br.com.softplan.security.zap.api.analysis.Analyzer;
import br.com.softplan.security.zap.api.exception.ZapAnalysisTimeoutException;
import br.com.softplan.security.zap.api.exception.ZapClientException;
import br.com.softplan.security.zap.api.model.AnalysisInfo;
import br.com.softplan.security.zap.api.model.ScanType;
import br.com.softplan.security.zap.api.report.ZapReport;
import com.sun.org.apache.xerces.internal.impl.io.MalformedByteSequenceException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXParseException;
import org.zaproxy.clientapi.core.ApiResponse;
import org.zaproxy.clientapi.core.ApiResponseElement;
import org.zaproxy.clientapi.core.ApiResponseList;
import org.zaproxy.clientapi.core.ClientApi;
import org.zaproxy.clientapi.core.ClientApiException;

public abstract class BaseAnalyzer
implements Analyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseAnalyzer.class);
    private static final long SPIDER_STATUS_POLLING_INTERVAL_IN_SECONDS = 1L;
    private static final long AJAX_SPIDER_STATUS_POLLING_INTERVAL_IN_SECONDS = 10L;
    private static final long ACTIVE_SCAN_STATUS_POLLING_INTERVAL_IN_SECONDS = 5L;
    private String apiKey;
    private ClientApi api;
    private long analysisTimeoutInMillis;
    private long analysisStartTime;
    private boolean spiderDidRun = false;

    public BaseAnalyzer(String apiKey, ClientApi api) {
        this.api = api;
        this.apiKey = apiKey;
    }

    protected void init(long analysisTimeoutInMillis) {
        this.analysisTimeoutInMillis = analysisTimeoutInMillis;
        this.analysisStartTime = System.currentTimeMillis();
    }

    protected void runSpider(AnalysisInfo analysisInfo) {
        String targetUrl = analysisInfo.getSpiderStartingPointUrl();
        LOGGER.info("{} : {}", (Object)ScanType.SPIDER, (Object)targetUrl);
        try {
            ApiResponse resp = this.api.spider.scan(targetUrl, "", "", "", "");
            String scanId = ((ApiResponseElement)resp).getValue();
            this.waitForScanToFinish(scanId, ScanType.SPIDER);
            this.spiderDidRun = true;
        }
        catch (ClientApiException e) {
            this.handleError("Error running Spider.", e);
        }
    }

    protected void runAjaxSpider(AnalysisInfo analysisInfo) {
        String targetUrl = analysisInfo.getSpiderStartingPointUrl();
        LOGGER.info("{} : {}", (Object)ScanType.AJAX_SPIDER, (Object)targetUrl);
        try {
            ApiResponse resp = this.api.ajaxSpider.scan(this.apiKey, targetUrl, "false");
            String scanId = ((ApiResponseElement)resp).getValue();
            this.waitForScanToFinish(scanId, ScanType.AJAX_SPIDER);
        }
        catch (ClientApiException e) {
            this.handleError("Error running Ajax Spider.", e);
        }
    }

    protected void runActiveScan(AnalysisInfo analysisInfo) {
        String targetUrl = analysisInfo.getActiveScanStartingPointUrl();
        LOGGER.info("{} : {}", (Object)ScanType.ACTIVE_SCAN, (Object)targetUrl);
        try {
            ApiResponse resp = this.api.ascan.scan(this.apiKey, targetUrl, "True", "True", "", "", "");
            String scanId = ((ApiResponseElement)resp).getValue();
            this.waitForScanToFinish(scanId, ScanType.ACTIVE_SCAN);
        }
        catch (ClientApiException e) {
            String message = "Error running Active Scan.";
            if (e.getCause() instanceof SAXParseException || e.getCause() instanceof MalformedByteSequenceException || e.getMessage().contains("URL Not Found in the Scan Tree")) {
                message = message + " One possible cause to this problem is that ZAP crashes when you try to run the Active Scan without any prior navigation made on the target (i.e. Spidering or proxied navigation were not done before on the Active Scan target).";
            }
            this.handleError(message, e);
        }
    }

    protected ZapReport generateReport() {
        LOGGER.info("Retrieving reports and Spider results...");
        ZapReport zapReport = null;
        try {
            byte[] htmlReport = this.api.core.htmlreport(this.apiKey);
            byte[] xmlReport = this.api.core.xmlreport(this.apiKey);
            List<String> spiderResults = this.getAndLogSpiderResults();
            zapReport = new ZapReport(htmlReport, xmlReport, spiderResults);
            LOGGER.info("Reports retrieved.");
        }
        catch (ClientApiException e) {
            this.handleError("Error retrieving reports.", e);
        }
        return zapReport;
    }

    private List<String> getAndLogSpiderResults() {
        ArrayList<String> urls = new ArrayList<String>();
        if (!this.spiderDidRun) {
            LOGGER.info("Spider did not run.");
            return urls;
        }
        try {
            ApiResponseList responseList = (ApiResponseList)this.api.spider.results("");
            LOGGER.debug("Visited URLs by the Spider:");
            for (ApiResponse response : responseList.getItems()) {
                String url = ((ApiResponseElement)response).getValue();
                LOGGER.debug("    {}", (Object)url);
                urls.add(url);
            }
        }
        catch (ClientApiException e) {
            this.handleError("Error retrieving Spider results.", e);
        }
        return urls;
    }

    private void waitForScanToFinish(String scanId, ScanType scanType) {
        int progress = 0;
        int maxProgress = 100;
        while (progress < 100) {
            switch (scanType) {
                case SPIDER: {
                    progress = this.waitSpider(scanId, progress);
                    break;
                }
                case AJAX_SPIDER: {
                    progress = this.waitAjaxSpider(scanId, progress);
                    break;
                }
                case ACTIVE_SCAN: {
                    progress = this.waitActiveScan(scanId, progress);
                }
            }
            LOGGER.info("{} progress : {}%", (Object)scanType, (Object)progress);
        }
        LOGGER.info("{} complete", (Object)scanType);
    }

    private int waitSpider(String scanId, int progress) {
        BaseAnalyzer.sleep(1L);
        int newProgress = progress;
        try {
            newProgress = Integer.parseInt(((ApiResponseElement)this.api.spider.status(scanId)).getValue());
        }
        catch (NumberFormatException | ClientApiException e) {
            this.handleError("Error retrieving Spider progress.", e);
        }
        if (this.scanTimeoutReached(scanId)) {
            try {
                this.api.spider.stop(this.apiKey, scanId);
                LOGGER.info("Spider STOPPED");
            }
            catch (ClientApiException e) {
                this.handleError("Error stopping Active Scan.", e);
            }
            String message = "Analysis did not finish before the timeout (" + this.analysisTimeoutInMillis + " ms).";
            LOGGER.error(message);
            throw new ZapAnalysisTimeoutException(message);
        }
        return newProgress;
    }

    private int waitAjaxSpider(String scanId, int progress) {
        BaseAnalyzer.sleep(10L);
        int newProgress = progress;
        try {
            newProgress = this.getAjaxSpiderProgress();
        }
        catch (ClientApiException e) {
            this.handleError("Error retrieving Ajax Spider progress.", e);
        }
        if (this.scanTimeoutReached(scanId)) {
            try {
                this.api.ajaxSpider.stop(scanId);
                LOGGER.info("AJAX Spider STOPPED");
            }
            catch (ClientApiException e) {
                this.handleError("Error stopping Active Scan.", e);
            }
            String message = "Analysis did not finish before the timeout (" + this.analysisTimeoutInMillis + " ms).";
            LOGGER.error(message);
            throw new ZapAnalysisTimeoutException(message);
        }
        return newProgress;
    }

    private int waitActiveScan(String scanId, int progress) {
        BaseAnalyzer.sleep(5L);
        int newProgress = progress;
        try {
            newProgress = Integer.parseInt(((ApiResponseElement)this.api.ascan.status(scanId)).getValue());
        }
        catch (NumberFormatException | ClientApiException e) {
            this.handleError("Error retrieving Active Scan progress.", e);
        }
        if (this.scanTimeoutReached(scanId)) {
            try {
                this.api.ascan.stop(this.apiKey, scanId);
                LOGGER.info("Active Scan STOPPED");
            }
            catch (ClientApiException e) {
                this.handleError("Error stopping Active Scan.", e);
            }
            String message = "Analysis did not finish before the timeout (" + this.analysisTimeoutInMillis + " ms).";
            LOGGER.error(message);
            throw new ZapAnalysisTimeoutException(message);
        }
        return newProgress;
    }

    private void handleError(String message, Throwable cause) {
        LOGGER.error(message, cause);
        throw new ZapClientException(message, cause);
    }

    private boolean scanTimeoutReached(String scanId) {
        long elapsedTimeInMillis = System.currentTimeMillis() - this.analysisStartTime;
        return elapsedTimeInMillis >= this.analysisTimeoutInMillis;
    }

    private int getAjaxSpiderProgress() throws ClientApiException {
        String progress = ((ApiResponseElement)this.api.ajaxSpider.status()).getValue();
        int maxProgress = 100;
        return progress.equalsIgnoreCase("running") ? 0 : 100;
    }

    private static void sleep(long seconds) {
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(seconds));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

