/*
 * Decompiled with CFR 0.152.
 */
package br.com.softplan.security.zap.api;

import br.com.softplan.security.zap.api.SessionManager;
import br.com.softplan.security.zap.api.ZapHelper;
import br.com.softplan.security.zap.api.analysis.Analyzer;
import br.com.softplan.security.zap.api.analysis.AnalyzerFactory;
import br.com.softplan.security.zap.api.authentication.AuthenticationHandler;
import br.com.softplan.security.zap.api.authentication.AuthenticationHandlerFactory;
import br.com.softplan.security.zap.api.model.AnalysisInfo;
import br.com.softplan.security.zap.api.model.AuthenticationInfo;
import br.com.softplan.security.zap.api.report.ZapReport;
import br.com.softplan.security.zap.commons.ZapInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zaproxy.clientapi.core.ClientApi;

public class ZapClient {
    private String apiKey;
    private ClientApi api;
    private AuthenticationHandler authenticationHandler;
    private SessionManager sessionManager;
    private static final Logger LOGGER = LoggerFactory.getLogger(ZapClient.class);

    public ZapClient(ZapInfo zapInfo) {
        this.api = new ClientApi(zapInfo.getHost(), zapInfo.getPort(), zapInfo.getApiKey());
        this.sessionManager = new SessionManager();
    }

    public ZapClient(ZapInfo zapInfo, AuthenticationInfo authenticationInfo) {
        this(zapInfo);
        this.authenticationHandler = AuthenticationHandlerFactory.makeHandler(this.api, zapInfo, authenticationInfo);
    }

    public ZapReport analyze(AnalysisInfo analysisInfo) {
        if (analysisInfo.shouldStartNewSession()) {
            this.sessionManager.createNewSession(this.api, this.apiKey);
        }
        ZapHelper.includeInContext(this.api, this.apiKey, analysisInfo);
        ZapHelper.setTechnologiesInContext(this.api, this.apiKey, analysisInfo);
        if (this.authenticationHandler != null) {
            this.authenticationHandler.handleAuthentication(analysisInfo.getTargetUrl());
        }
        LOGGER.info("--- Starting analysis ---");
        Analyzer analyzer = AnalyzerFactory.makeAnalyzer(this.apiKey, this.api, analysisInfo);
        ZapReport zapReport = analyzer.analyze(analysisInfo);
        LOGGER.info("--- Finished analysis ---\n");
        return zapReport;
    }
}

