/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.tck;

import com.github.tomakehurst.wiremock.http.Body;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;

public final class TestResponse {
    private final int status;
    private final Body body;

    public static TestResponse of(ResponseDefinition def) {
        return TestResponse.builder().status(def.getStatus()).body(def.getReponseBody()).build();
    }

    TestResponse(int status, Body body) {
        this.status = status;
        this.body = body;
    }

    public static TestResponseBuilder builder() {
        return new TestResponseBuilder();
    }

    public int getStatus() {
        return this.status;
    }

    public Body getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestResponse)) {
            return false;
        }
        TestResponse other = (TestResponse)o;
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        Body this$body = this.getBody();
        Body other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        Body $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "TestResponse(status=" + this.getStatus() + ", body=" + this.getBody() + ")";
    }

    public static class TestResponseBuilder {
        private int status;
        private Body body;

        TestResponseBuilder() {
        }

        public TestResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public TestResponseBuilder body(Body body) {
            this.body = body;
            return this;
        }

        public TestResponse build() {
            return new TestResponse(this.status, this.body);
        }

        public String toString() {
            return "TestResponse.TestResponseBuilder(status=" + this.status + ", body=" + this.body + ")";
        }
    }
}

