/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.tck;

import com.github.tomakehurst.wiremock.matching.MultiValuePattern;
import com.github.tomakehurst.wiremock.matching.RequestPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TestRequest {
    private final String url;
    private final String method;
    private final Map<String, List<String>> headers;

    public String getAbsoluteUrl() {
        return "https://example.com" + this.url;
    }

    public static TestRequest of(RequestPattern pattern) {
        return TestRequest.builder().url(pattern.getUrl()).method(pattern.getMethod().toString()).headers(TestRequest.convertHeaders(pattern.getHeaders())).build();
    }

    private static Map<String, List<String>> convertHeaders(Map<String, MultiValuePattern> m) {
        if (m == null) {
            return null;
        }
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (Map.Entry<String, MultiValuePattern> e : m.entrySet()) {
            ArrayList<String> values = new ArrayList<String>();
            values.add((String)e.getValue().getValuePattern().getValue());
            result.put(e.getKey(), values);
        }
        return result;
    }

    TestRequest(String url, String method, Map<String, List<String>> headers) {
        this.url = url;
        this.method = method;
        this.headers = headers;
    }

    public static TestRequestBuilder builder() {
        return new TestRequestBuilder();
    }

    public String getUrl() {
        return this.url;
    }

    public String getMethod() {
        return this.method;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestRequest)) {
            return false;
        }
        TestRequest other = (TestRequest)o;
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        return !(this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        return result;
    }

    public String toString() {
        return "TestRequest(url=" + this.getUrl() + ", method=" + this.getMethod() + ", headers=" + this.getHeaders() + ")";
    }

    public static class TestRequestBuilder {
        private String url;
        private String method;
        private Map<String, List<String>> headers;

        TestRequestBuilder() {
        }

        public TestRequestBuilder url(String url) {
            this.url = url;
            return this;
        }

        public TestRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public TestRequestBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public TestRequest build() {
            return new TestRequest(this.url, this.method, this.headers);
        }

        public String toString() {
            return "TestRequest.TestRequestBuilder(url=" + this.url + ", method=" + this.method + ", headers=" + this.headers + ")";
        }
    }
}

