/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.tck;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.stubbing.StubImport;
import de.martinpallmann.mockbridge.tck.TestRequest;
import de.martinpallmann.mockbridge.tck.TestResponse;
import de.martinpallmann.mockbridge.tck.api.MappingFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.TestFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TckSuite {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    protected abstract TestResponse send(TestRequest var1) throws Exception;

    @TestFactory
    Stream<DynamicTest> tests() throws IOException {
        return this.getMappings().stream().flatMap(s -> {
            List mappings = MappingFactory.of("/mappings/" + s).getMappingOrMappings();
            return mappings.stream().map(mapping -> {
                WireMock.importStubs((StubImport)StubImport.stubImport().stub(mapping).build());
                return DynamicTest.dynamicTest((String)TckSuite.name(s, mapping.getName()), () -> {
                    TestRequest request = TestRequest.of(mapping.getRequest());
                    Assertions.assertEquals((Object)TestResponse.of(mapping.getResponse()), (Object)this.send(request));
                });
            });
        });
    }

    private static String name(String file, String mapping) {
        if (mapping == null) {
            return file;
        }
        return file + "/" + mapping;
    }

    private List<String> getMappings() throws IOException {
        ArrayList<String> filenames = new ArrayList<String>();
        try (InputStream in = this.getClass().getResourceAsStream("/mappings");
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String resource;
            while ((resource = br.readLine()) != null) {
                filenames.add(resource);
            }
        }
        return filenames;
    }
}

