/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.jdk;

import com.github.tomakehurst.wiremock.direct.DirectCallHttpServer;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.Response;
import de.martinpallmann.mockbridge.jdk.api.JdkRequest;
import de.martinpallmann.mockbridge.jdk.api.JdkResponseInfo;
import de.martinpallmann.mockbridge.jdk.api.ResponseSubscription;
import de.martinpallmann.mockbridge.jdk.api.WiremockResponse;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;

public class MockBridge
extends HttpClient {
    private final DirectCallHttpServer server;
    private final HttpClient.Version version;
    private final HttpClient.Redirect followRedirects;
    private final CookieHandler cookieHandler;
    private final ProxySelector proxySelector;
    private final Authenticator authenticator;
    private final Duration connectTimeout;

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return Optional.ofNullable(this.cookieHandler);
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.followRedirects;
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.ofNullable(this.proxySelector);
    }

    @Override
    public SSLContext sslContext() {
        return null;
    }

    @Override
    public SSLParameters sslParameters() {
        return null;
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    @Override
    public HttpClient.Version version() {
        return this.version;
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.empty();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        CompletableFuture<HttpResponse<T>> cf = null;
        try {
            cf = this.sendAsync(request, responseBodyHandler, null);
            return cf.get();
        }
        catch (InterruptedException ie) {
            if (cf != null) {
                cf.cancel(true);
            }
            throw ie;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            String msg = throwable.getMessage();
            if (throwable instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(msg, throwable);
            }
            if (throwable instanceof SecurityException) {
                throw new SecurityException(msg, throwable);
            }
            if (throwable instanceof HttpConnectTimeoutException) {
                HttpConnectTimeoutException hcte = new HttpConnectTimeoutException(msg);
                hcte.initCause(throwable);
                throw hcte;
            }
            if (throwable instanceof HttpTimeoutException) {
                throw new HttpTimeoutException(msg);
            }
            if (throwable instanceof ConnectException) {
                ConnectException ce = new ConnectException(msg);
                ce.initCause(throwable);
                throw ce;
            }
            if (throwable instanceof SSLHandshakeException) {
                SSLHandshakeException he = new SSLHandshakeException(msg);
                he.initCause(throwable);
                throw he;
            }
            if (throwable instanceof SSLException) {
                throw new SSLException(msg, throwable);
            }
            if (throwable instanceof IOException) {
                throw new IOException(msg, throwable);
            }
            throw new IOException(msg, throwable);
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseHandler) {
        return this.sendAsync(request, responseHandler, null);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        Response response = this.server.stubRequest((Request)new JdkRequest(httpRequest));
        HttpResponse.ResponseInfo responseInfo = JdkResponseInfo.of(this.version, response);
        HttpResponse.BodySubscriber<T> subscriber = bodyHandler.apply(responseInfo);
        subscriber.onSubscribe(new ResponseSubscription(subscriber, response));
        return subscriber.getBody().thenApply(WiremockResponse.of(httpRequest, response)).toCompletableFuture();
    }

    private static HttpClient.Version $default$version() {
        return HttpClient.Version.HTTP_1_1;
    }

    private static HttpClient.Redirect $default$followRedirects() {
        return HttpClient.Redirect.NEVER;
    }

    public static MockBridgeBuilder builder() {
        return new MockBridgeBuilder();
    }

    private MockBridge(DirectCallHttpServer server, HttpClient.Version version, HttpClient.Redirect followRedirects, CookieHandler cookieHandler, ProxySelector proxySelector, Authenticator authenticator, Duration connectTimeout) {
        this.server = server;
        this.version = version;
        this.followRedirects = followRedirects;
        this.cookieHandler = cookieHandler;
        this.proxySelector = proxySelector;
        this.authenticator = authenticator;
        this.connectTimeout = connectTimeout;
    }

    public static class MockBridgeBuilder {
        private DirectCallHttpServer server;
        private boolean version$set;
        private HttpClient.Version version$value;
        private boolean followRedirects$set;
        private HttpClient.Redirect followRedirects$value;
        private CookieHandler cookieHandler;
        private ProxySelector proxySelector;
        private Authenticator authenticator;
        private Duration connectTimeout;

        MockBridgeBuilder() {
        }

        public MockBridgeBuilder server(DirectCallHttpServer server) {
            this.server = server;
            return this;
        }

        public MockBridgeBuilder version(HttpClient.Version version) {
            this.version$value = version;
            this.version$set = true;
            return this;
        }

        public MockBridgeBuilder followRedirects(HttpClient.Redirect followRedirects) {
            this.followRedirects$value = followRedirects;
            this.followRedirects$set = true;
            return this;
        }

        public MockBridgeBuilder cookieHandler(CookieHandler cookieHandler) {
            this.cookieHandler = cookieHandler;
            return this;
        }

        public MockBridgeBuilder proxySelector(ProxySelector proxySelector) {
            this.proxySelector = proxySelector;
            return this;
        }

        public MockBridgeBuilder authenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
            return this;
        }

        public MockBridgeBuilder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public MockBridge build() {
            HttpClient.Version version$value = this.version$value;
            if (!this.version$set) {
                version$value = MockBridge.$default$version();
            }
            HttpClient.Redirect followRedirects$value = this.followRedirects$value;
            if (!this.followRedirects$set) {
                followRedirects$value = MockBridge.$default$followRedirects();
            }
            return new MockBridge(this.server, version$value, followRedirects$value, this.cookieHandler, this.proxySelector, this.authenticator, this.connectTimeout);
        }

        public String toString() {
            return "MockBridge.MockBridgeBuilder(server=" + this.server + ", version$value=" + this.version$value + ", followRedirects$value=" + this.followRedirects$value + ", cookieHandler=" + this.cookieHandler + ", proxySelector=" + this.proxySelector + ", authenticator=" + this.authenticator + ", connectTimeout=" + this.connectTimeout + ")";
        }
    }
}

