/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.jdk.api;

import com.github.tomakehurst.wiremock.http.Response;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.Flow;

public class ResponseSubscription
implements Flow.Subscription {
    private final Flow.Subscriber<List<ByteBuffer>> subscriber;
    private final Response response;

    @Override
    public void request(long n) {
        if (n > 0L) {
            if (this.response.getBody() != null) {
                this.subscriber.onNext(List.of(ByteBuffer.wrap(this.response.getBody())));
            }
            this.subscriber.onComplete();
        } else {
            this.subscriber.onError(new IllegalArgumentException("n must be > 0"));
        }
    }

    @Override
    public void cancel() {
        this.subscriber.onComplete();
    }

    public ResponseSubscription(Flow.Subscriber<List<ByteBuffer>> subscriber, Response response) {
        this.subscriber = subscriber;
        this.response = response;
    }
}

