/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.jdk.api;

import com.github.tomakehurst.wiremock.common.Encoding;
import com.github.tomakehurst.wiremock.common.Urls;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.Cookie;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.QueryParameter;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import de.martinpallmann.mockbridge.jdk.api.ByteBufferSubscriber;
import de.martinpallmann.mockbridge.jdk.api.Converter;
import java.net.URI;
import java.net.http.HttpRequest;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkRequest
implements Request {
    private final Logger logger = LoggerFactory.getLogger(JdkRequest.class);
    private final HttpRequest wrapped;
    private final Converter converter;

    public static Request request(HttpRequest wrapped) {
        return new JdkRequest(wrapped, Converter.getInstance());
    }

    public String getUrl() {
        String result = this.wrapped.uri().getPath();
        this.logger.debug("getUrl: {}", (Object)result);
        return result;
    }

    public String getAbsoluteUrl() {
        String result = this.wrapped.uri().toString();
        this.logger.debug("getAbsoluteUrl: {}", (Object)result);
        return result;
    }

    public RequestMethod getMethod() {
        RequestMethod result = RequestMethod.fromString((String)this.wrapped.method());
        this.logger.debug("getMethod: {}", (Object)result);
        return result;
    }

    public String getScheme() {
        String result = this.wrapped.uri().getScheme();
        this.logger.debug("getScheme: {}", (Object)result);
        return result;
    }

    public String getHost() {
        String result = this.wrapped.uri().getHost();
        this.logger.debug("getHost: {}", (Object)result);
        return result;
    }

    public int getPort() {
        int result = this.wrapped.uri().getPort();
        this.logger.debug("getPort: {}", (Object)result);
        return result;
    }

    public String getClientIp() {
        this.logger.debug("getClientIp: 127.0.0.1");
        return "127.0.0.1";
    }

    private Optional<String> firstHeader(String s) {
        return this.wrapped.headers().firstValue(s);
    }

    public String getHeader(String s) {
        String result = this.firstHeader(s).orElse(null);
        this.logger.debug("getHeader: {}", (Object)result);
        return result;
    }

    public HttpHeader header(String s) {
        HttpHeader result = this.firstHeader(s).isEmpty() ? HttpHeader.empty((String)s) : HttpHeader.httpHeader((String)s, (String[])this.wrapped.headers().allValues(s).toArray(new String[0]));
        this.logger.debug("header: {}", (Object)result);
        return result;
    }

    public ContentTypeHeader contentTypeHeader() {
        ContentTypeHeader result = this.firstHeader("Content-Type").map(ContentTypeHeader::new).orElse(ContentTypeHeader.absent());
        this.logger.debug("contentTypeHeader: {}", (Object)result);
        return result;
    }

    public HttpHeaders getHeaders() {
        HttpHeaders result = this.converter.fromJdk(this.wrapped.headers());
        this.logger.debug("getHeaders: {}", (Object)result);
        return result;
    }

    public boolean containsHeader(String s) {
        boolean result = this.firstHeader(s).isPresent();
        this.logger.debug("containsHeader: {}", (Object)result);
        return result;
    }

    public Set<String> getAllHeaderKeys() {
        Set<String> result = this.wrapped.headers().map().keySet();
        this.logger.debug("getAllHeaderKeys: {}", result);
        return result;
    }

    public Map<String, Cookie> getCookies() {
        return Map.of();
    }

    public QueryParameter queryParameter(String key) {
        Map query = Urls.splitQuery((URI)this.wrapped.uri());
        QueryParameter result = (QueryParameter)query.get(key);
        this.logger.debug("queryParameter: {}", (Object)result);
        return result;
    }

    public byte[] getBody() {
        ByteBufferSubscriber subscriber = new ByteBufferSubscriber();
        this.wrapped.bodyPublisher().ifPresent(s -> s.subscribe(subscriber));
        return subscriber.result();
    }

    public String getBodyAsString() {
        return new String(this.getBody(), StandardCharsets.UTF_8);
    }

    public String getBodyAsBase64() {
        return Encoding.encodeBase64((byte[])this.getBody());
    }

    public boolean isMultipart() {
        return false;
    }

    public Collection<Request.Part> getParts() {
        return Collections.emptySet();
    }

    public Request.Part getPart(String s) {
        return null;
    }

    public boolean isBrowserProxyRequest() {
        return false;
    }

    public com.google.common.base.Optional<Request> getOriginalRequest() {
        return com.google.common.base.Optional.absent();
    }

    private JdkRequest(HttpRequest wrapped, Converter converter) {
        this.wrapped = wrapped;
        this.converter = converter;
    }
}

