/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.jdk.api;

import com.github.tomakehurst.wiremock.http.Response;
import de.martinpallmann.mockbridge.jdk.api.Converter;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpHeaders;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.function.Function;
import javax.net.ssl.SSLSession;

public class WiremockResponse<T>
implements HttpResponse<T> {
    private final T body;
    private final HttpRequest request;
    private final Response response;
    private final Converter converter = Converter.getInstance();

    public static <T> Function<T, HttpResponse<T>> of(HttpRequest request, Response response) {
        return body -> new WiremockResponse<Object>(body, request, response);
    }

    @Override
    public int statusCode() {
        return this.response.getStatus();
    }

    @Override
    public HttpRequest request() {
        return this.request;
    }

    @Override
    public Optional<HttpResponse<T>> previousResponse() {
        return Optional.empty();
    }

    @Override
    public HttpHeaders headers() {
        return this.converter.fromWiremock(this.response.getHeaders());
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public Optional<SSLSession> sslSession() {
        return Optional.empty();
    }

    @Override
    public URI uri() {
        return this.request.uri();
    }

    @Override
    public HttpClient.Version version() {
        return this.request.version().orElse(HttpClient.Version.HTTP_1_1);
    }

    private WiremockResponse(T body, HttpRequest request, Response response) {
        this.body = body;
        this.request = request;
        this.response = response;
    }
}

