/*
 * Decompiled with CFR 0.152.
 */
package de.martinpallmann.mockbridge.jdk;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.direct.DirectCallHttpServer;
import com.github.tomakehurst.wiremock.direct.DirectCallHttpServerFactory;
import com.github.tomakehurst.wiremock.http.HttpServerFactory;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.verification.LoggedRequest;
import com.github.tomakehurst.wiremock.verification.NearMiss;
import de.martinpallmann.mockbridge.jdk.api.DirectWireMockServer;
import de.martinpallmann.mockbridge.jdk.api.JdkRequest;
import de.martinpallmann.mockbridge.jdk.api.JdkResponseInfo;
import de.martinpallmann.mockbridge.jdk.api.ResponseSubscription;
import de.martinpallmann.mockbridge.jdk.api.WiremockResponse;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.CookieHandler;
import java.net.ProxySelector;
import java.net.http.HttpClient;
import java.net.http.HttpConnectTimeoutException;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.net.http.HttpTimeoutException;
import java.time.Duration;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLParameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockBridge
extends HttpClient {
    private static final Logger logger = LoggerFactory.getLogger(MockBridge.class);
    private final DirectCallHttpServer server;
    private final HttpClient.Version version;
    private final HttpClient.Redirect followRedirects;
    private final CookieHandler cookieHandler;
    private final ProxySelector proxySelector;
    private final Authenticator authenticator;
    private final Duration connectTimeout;

    public static MockBridge httpClient(WireMockConfiguration configuration) {
        DirectCallHttpServerFactory factory = new DirectCallHttpServerFactory();
        new DirectWireMockServer(configuration, (HttpServerFactory)factory);
        return new MockBridge(factory.getHttpServer(), HttpClient.Version.HTTP_1_1, HttpClient.Redirect.NEVER, null, null, null, null);
    }

    public static MockBridge httpClient() {
        return MockBridge.httpClient(WireMockConfiguration.wireMockConfig());
    }

    @Override
    public Optional<CookieHandler> cookieHandler() {
        return Optional.ofNullable(this.cookieHandler);
    }

    public MockBridge cookieHandler(CookieHandler cookieHandler) {
        return new MockBridge(this.server, this.version, this.followRedirects, cookieHandler, this.proxySelector, this.authenticator, this.connectTimeout);
    }

    @Override
    public Optional<Duration> connectTimeout() {
        return Optional.ofNullable(this.connectTimeout);
    }

    public MockBridge connectTimeout(Duration connectTimeout) {
        return new MockBridge(this.server, this.version, this.followRedirects, this.cookieHandler, this.proxySelector, this.authenticator, connectTimeout);
    }

    @Override
    public HttpClient.Redirect followRedirects() {
        return this.followRedirects;
    }

    public MockBridge followRedirects(HttpClient.Redirect followRedirects) {
        return new MockBridge(this.server, this.version, followRedirects, this.cookieHandler, this.proxySelector, this.authenticator, this.connectTimeout);
    }

    @Override
    public Optional<ProxySelector> proxy() {
        return Optional.ofNullable(this.proxySelector);
    }

    public MockBridge proxy(ProxySelector proxySelector) {
        return new MockBridge(this.server, this.version, this.followRedirects, this.cookieHandler, proxySelector, this.authenticator, this.connectTimeout);
    }

    @Override
    public SSLContext sslContext() {
        return null;
    }

    @Override
    public SSLParameters sslParameters() {
        return null;
    }

    @Override
    public Optional<Authenticator> authenticator() {
        return Optional.ofNullable(this.authenticator);
    }

    public MockBridge authenticator(Authenticator authenticator) {
        return new MockBridge(this.server, this.version, this.followRedirects, this.cookieHandler, this.proxySelector, authenticator, this.connectTimeout);
    }

    @Override
    public HttpClient.Version version() {
        return this.version;
    }

    public MockBridge version(HttpClient.Version version) {
        return new MockBridge(this.server, version, this.followRedirects, this.cookieHandler, this.proxySelector, this.authenticator, this.connectTimeout);
    }

    @Override
    public Optional<Executor> executor() {
        return Optional.empty();
    }

    @Override
    public <T> HttpResponse<T> send(HttpRequest request, HttpResponse.BodyHandler<T> responseBodyHandler) throws IOException, InterruptedException {
        CompletableFuture<HttpResponse<T>> cf = null;
        try {
            cf = this.sendAsync(request, responseBodyHandler, null);
            HttpResponse<T> result = cf.get();
            return result;
        }
        catch (InterruptedException ie) {
            if (cf != null) {
                cf.cancel(true);
            }
            throw ie;
        }
        catch (ExecutionException e) {
            Throwable throwable = e.getCause();
            String msg = throwable.getMessage();
            if (throwable instanceof IllegalArgumentException) {
                throw new IllegalArgumentException(msg, throwable);
            }
            if (throwable instanceof SecurityException) {
                throw new SecurityException(msg, throwable);
            }
            if (throwable instanceof HttpConnectTimeoutException) {
                HttpConnectTimeoutException hcte = new HttpConnectTimeoutException(msg);
                hcte.initCause(throwable);
                throw hcte;
            }
            if (throwable instanceof HttpTimeoutException) {
                throw new HttpTimeoutException(msg);
            }
            if (throwable instanceof ConnectException) {
                ConnectException ce = new ConnectException(msg);
                ce.initCause(throwable);
                throw ce;
            }
            if (throwable instanceof SSLHandshakeException) {
                SSLHandshakeException he = new SSLHandshakeException(msg);
                he.initCause(throwable);
                throw he;
            }
            if (throwable instanceof SSLException) {
                throw new SSLException(msg, throwable);
            }
            if (throwable instanceof IOException) {
                throw new IOException(msg, throwable);
            }
            throw new IOException(msg, throwable);
        }
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest request, HttpResponse.BodyHandler<T> responseHandler) {
        return this.sendAsync(request, responseHandler, null);
    }

    @Override
    public <T> CompletableFuture<HttpResponse<T>> sendAsync(HttpRequest httpRequest, HttpResponse.BodyHandler<T> bodyHandler, HttpResponse.PushPromiseHandler<T> pushPromiseHandler) {
        Response response = this.server.stubRequest(JdkRequest.request(httpRequest));
        for (LoggedRequest r : WireMock.findUnmatchedRequests()) {
            logger.warn("unmatched request: {}", (Object)r);
            for (NearMiss m : WireMock.findNearMissesFor((LoggedRequest)r)) {
                logger.warn("near miss: {}", (Object)m);
            }
        }
        HttpResponse.ResponseInfo responseInfo = JdkResponseInfo.responseInfo(this.version, response);
        HttpResponse.BodySubscriber<T> subscriber = bodyHandler.apply(responseInfo);
        subscriber.onSubscribe(new ResponseSubscription(subscriber, response));
        return subscriber.getBody().thenApply(WiremockResponse.of(httpRequest, response)).toCompletableFuture();
    }

    private MockBridge(DirectCallHttpServer server, HttpClient.Version version, HttpClient.Redirect followRedirects, CookieHandler cookieHandler, ProxySelector proxySelector, Authenticator authenticator, Duration connectTimeout) {
        this.server = server;
        this.version = version;
        this.followRedirects = followRedirects;
        this.cookieHandler = cookieHandler;
        this.proxySelector = proxySelector;
        this.authenticator = authenticator;
        this.connectTimeout = connectTimeout;
    }
}

