/*
 * Decompiled with CFR 0.152.
 */
package de.marcoaust.prometheus;

import io.prometheus.client.Collector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.endpoint.PublicMetrics;
import org.springframework.boot.actuate.metrics.Metric;
import org.springframework.stereotype.Component;

@Component
class SpringBootMetricsCollector
extends Collector {
    private final Collection<PublicMetrics> publicMetrics;

    @Autowired
    SpringBootMetricsCollector(Collection<PublicMetrics> publicMetrics) {
        this.publicMetrics = publicMetrics;
    }

    public List<Collector.MetricFamilySamples> collect() {
        HashMap<String, Collector.MetricFamilySamples> samples = new HashMap<String, Collector.MetricFamilySamples>();
        for (PublicMetrics publicMetrics : this.publicMetrics) {
            for (Metric metric : publicMetrics.metrics()) {
                String name = Collector.sanitizeMetricName((String)metric.getName());
                double value = metric.getValue().doubleValue();
                Collector.MetricFamilySamples metricFamilySamples = new Collector.MetricFamilySamples(name, Collector.Type.GAUGE, name, Collections.singletonList(new Collector.MetricFamilySamples.Sample(name, new ArrayList(), new ArrayList(), value)));
                samples.put(name, metricFamilySamples);
            }
        }
        return new ArrayList<Collector.MetricFamilySamples>(samples.values());
    }
}

