/*
 * Decompiled with CFR 0.152.
 */
package de.marcoaust.prometheus;

import io.prometheus.client.CollectorRegistry;
import io.prometheus.client.exporter.common.TextFormat;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.Endpoint;
import org.springframework.stereotype.Component;

@Component
class PrometheusEnpoint
implements Endpoint<String> {
    private static final Logger log = LoggerFactory.getLogger(PrometheusEnpoint.class);
    private CollectorRegistry collectorRegistry = CollectorRegistry.defaultRegistry;

    PrometheusEnpoint() {
    }

    public String getId() {
        return "prometheus";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isSensitive() {
        return true;
    }

    public String invoke() {
        try {
            StringWriter writer = new StringWriter();
            TextFormat.write004((Writer)writer, (Enumeration)this.collectorRegistry.metricFamilySamples());
            return ((Object)writer).toString();
        }
        catch (IOException e) {
            log.error("Writing metrics failed", (Throwable)e);
            return "";
        }
    }
}

