/*
 * Decompiled with CFR 0.152.
 */
package com.bluelinelabs.logansquare;

import com.bluelinelabs.logansquare.LoganSquare;
import com.bluelinelabs.logansquare.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public final class ConverterUtils {
    private ConverterUtils() {
        throw new AssertionError();
    }

    public static boolean isSupported(Type type) {
        if (type instanceof Class && !LoganSquare.supports((Class)((Class)type))) {
            return false;
        }
        if (type instanceof ParameterizedType && !LoganSquare.supports((ParameterizedType)((ParameterizedType)type))) {
            return false;
        }
        if (type instanceof java.lang.reflect.ParameterizedType) {
            java.lang.reflect.ParameterizedType pt = (java.lang.reflect.ParameterizedType)type;
            Type[] typeArguments = pt.getActualTypeArguments();
            Type firstType = typeArguments[0];
            Type rawType = pt.getRawType();
            if (rawType == Map.class) {
                Type secondType = typeArguments[1];
                if (firstType != String.class || !ConverterUtils.isSupported(secondType)) {
                    return false;
                }
            } else if (rawType == List.class) {
                if (!ConverterUtils.isSupported(firstType)) {
                    return false;
                }
            } else {
                return LoganSquare.supports((ParameterizedType)ConverterUtils.parameterizedTypeOf(type));
            }
        }
        return true;
    }

    public static ParameterizedType parameterizedTypeOf(Type type) {
        return new ParameterizedType.ConcreteParameterizedType(type);
    }
}

