/*
 * Decompiled with CFR 0.152.
 */
package de.mannodermaus.gradle.plugins.junit5.internal.config;

import com.android.build.api.dsl.CommonExtension;
import com.android.build.api.variant.AndroidComponentsExtension;
import com.android.build.api.variant.Variant;
import com.android.build.gradle.AppExtension;
import com.android.build.gradle.AppPlugin;
import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.BasePlugin;
import com.android.build.gradle.DynamicFeaturePlugin;
import com.android.build.gradle.LibraryExtension;
import com.android.build.gradle.LibraryPlugin;
import com.android.build.gradle.api.BaseVariant;
import com.android.build.gradle.api.TestVariant;
import de.mannodermaus.gradle.plugins.junit5.internal.extensions.BaseVariantExtKt;
import de.mannodermaus.gradle.plugins.junit5.internal.providers.DirectoryProvider;
import de.mannodermaus.gradle.plugins.junit5.internal.providers.JavaDirectoryProvider;
import de.mannodermaus.gradle.plugins.junit5.internal.providers.KotlinDirectoryProvider;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\b\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J*\u0010\u0016\u001a\u00020\u00172\"\u0010\u0018\u001a\u001e\u0012\u0014\u0012\u0012\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001a\u0012\u0004\u0012\u00020\u00170\u0019J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u001d\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00170\u0019R\u001a\u0010\u0007\u001a\u000e\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0012\u0002\b\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0016\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lde/mannodermaus/gradle/plugins/junit5/internal/config/PluginConfig;", "", "project", "Lorg/gradle/api/Project;", "legacyVariants", "Lorg/gradle/api/DomainObjectSet;", "Lcom/android/build/gradle/api/BaseVariant;", "componentsExtension", "Lcom/android/build/api/variant/AndroidComponentsExtension;", "(Lorg/gradle/api/Project;Lorg/gradle/api/DomainObjectSet;Lcom/android/build/api/variant/AndroidComponentsExtension;)V", "hasJacocoPlugin", "", "getHasJacocoPlugin", "()Z", "hasKotlinPlugin", "getHasKotlinPlugin", "directoryProvidersOf", "", "Lde/mannodermaus/gradle/plugins/junit5/internal/providers/DirectoryProvider;", "variant", "Lcom/android/build/api/variant/Variant;", "legacyVariant", "finalizeDsl", "", "block", "Lkotlin/Function1;", "Lcom/android/build/api/dsl/CommonExtension;", "instrumentationTestVariantOf", "Lcom/android/build/gradle/api/TestVariant;", "onVariants", "Companion", "android-junit5"})
public final class PluginConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final DomainObjectSet<? extends BaseVariant> legacyVariants;
    @NotNull
    private final AndroidComponentsExtension<?, ?, ?> componentsExtension;

    private PluginConfig(Project project, DomainObjectSet<? extends BaseVariant> legacyVariants, AndroidComponentsExtension<?, ?, ?> componentsExtension) {
        this.project = project;
        this.legacyVariants = legacyVariants;
        this.componentsExtension = componentsExtension;
    }

    public final boolean getHasJacocoPlugin() {
        return this.project.getPlugins().hasPlugin("jacoco");
    }

    private final boolean getHasKotlinPlugin() {
        return this.project.getPlugins().findPlugin("kotlin-android") != null;
    }

    public final void finalizeDsl(@NotNull Function1<? super CommonExtension<?, ?, ?, ?>, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.componentsExtension.finalizeDsl(block);
    }

    public final void onVariants(@NotNull Function1<? super Variant, Unit> block) {
        Intrinsics.checkNotNullParameter(block, (String)"block");
        AndroidComponentsExtension.DefaultImpls.onVariants$default(this.componentsExtension, null, block, (int)1, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final Set<DirectoryProvider> directoryProvidersOf(@NotNull Variant variant) {
        Set<DirectoryProvider> set;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Iterable $this$firstOrNull$iv = (Iterable)this.legacyVariants;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BaseVariant it = (BaseVariant)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)variant.getName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        BaseVariant baseVariant = v0;
        if (baseVariant != null) {
            BaseVariant $this$directoryProvidersOf_u24lambda_u2d1 = baseVariant;
            boolean bl = false;
            Set<DirectoryProvider> set2 = this.directoryProvidersOf($this$directoryProvidersOf_u24lambda_u2d1);
            if (set2 != null) {
                set = set2;
                return set;
            }
        }
        set = SetsKt.emptySet();
        return set;
    }

    @Nullable
    public final TestVariant instrumentationTestVariantOf(@NotNull Variant variant) {
        TestVariant testVariant;
        Object v0;
        block3: {
            Intrinsics.checkNotNullParameter((Object)variant, (String)"variant");
            Iterable $this$firstOrNull$iv = (Iterable)this.legacyVariants;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                BaseVariant it = (BaseVariant)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)variant.getName())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        BaseVariant baseVariant = v0;
        if (baseVariant != null) {
            BaseVariant $this$instrumentationTestVariantOf_u24lambda_u2d3 = baseVariant;
            boolean bl = false;
            testVariant = BaseVariantExtKt.getInstrumentationTestVariant($this$instrumentationTestVariantOf_u24lambda_u2d3);
        } else {
            testVariant = null;
        }
        return testVariant;
    }

    private final Set<DirectoryProvider> directoryProvidersOf(BaseVariant legacyVariant) {
        Set set;
        Set $this$directoryProvidersOf_u24lambda_u2d4 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        $this$directoryProvidersOf_u24lambda_u2d4.add(new JavaDirectoryProvider(legacyVariant));
        if (this.getHasKotlinPlugin()) {
            $this$directoryProvidersOf_u24lambda_u2d4.add(new KotlinDirectoryProvider(this.project, legacyVariant));
        }
        return SetsKt.build((Set)set);
    }

    public /* synthetic */ PluginConfig(Project project, DomainObjectSet legacyVariants, AndroidComponentsExtension componentsExtension, DefaultConstructorMarker $constructor_marker) {
        this(project, (DomainObjectSet<? extends BaseVariant>)legacyVariants, componentsExtension);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lde/mannodermaus/gradle/plugins/junit5/internal/config/PluginConfig$Companion;", "", "()V", "find", "Lde/mannodermaus/gradle/plugins/junit5/internal/config/PluginConfig;", "project", "Lorg/gradle/api/Project;", "plugin", "Lcom/android/build/gradle/BasePlugin;", "android-junit5"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final PluginConfig find(@NotNull Project project, @NotNull BasePlugin plugin) {
            DomainObjectSet domainObjectSet;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)plugin, (String)"plugin");
            Object object = project.getExtensions().findByName("androidComponents");
            AndroidComponentsExtension androidComponentsExtension = object instanceof AndroidComponentsExtension ? (AndroidComponentsExtension)object : null;
            if (androidComponentsExtension == null) {
                return null;
            }
            AndroidComponentsExtension componentsExtension = androidComponentsExtension;
            Object object2 = project.getExtensions().findByName("android");
            BaseExtension baseExtension = object2 instanceof BaseExtension ? (BaseExtension)object2 : null;
            if (baseExtension == null) {
                return null;
            }
            BaseExtension legacyExtension = baseExtension;
            object2 = plugin;
            if (object2 instanceof AppPlugin) {
                domainObjectSet = ((AppExtension)legacyExtension).getApplicationVariants();
            } else if (object2 instanceof LibraryPlugin) {
                domainObjectSet = (DomainObjectSet)((LibraryExtension)legacyExtension).getLibraryVariants();
            } else if (object2 instanceof DynamicFeaturePlugin) {
                domainObjectSet = ((AppExtension)legacyExtension).getApplicationVariants();
            } else {
                return null;
            }
            DomainObjectSet legacyVariants = domainObjectSet;
            return new PluginConfig(project, legacyVariants, componentsExtension, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

