/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.mojo;

import de.malkusch.whoisServerList.api.v1.model.DomainList;
import de.malkusch.whoisServerList.compiler.DomainListCompiler;
import de.malkusch.whoisServerList.compiler.list.exception.BuildListException;
import java.io.File;
import javax.annotation.concurrent.Immutable;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Immutable
@Mojo(name="xml")
public final class XMLMojo
extends AbstractMojo {
    @Parameter(required=true)
    private File file;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            DomainListCompiler compiler = new DomainListCompiler();
            DomainList list = compiler.compile();
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{DomainList.class});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal((Object)list, this.file);
        }
        catch (BuildListException | JAXBException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoFailureException(e.getMessage(), (Throwable)e);
        }
    }
}

