/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.api.v1.model.WhoisServer;
import de.malkusch.whoisServerList.compiler.merger.Merger;
import de.malkusch.whoisServerList.compiler.merger.NotNullMerger;
import de.malkusch.whoisServerList.compiler.merger.StringMerger;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
final class WhoisServerMerger
implements Merger<WhoisServer> {
    private final StringMerger stringMerger = new StringMerger();
    private final NotNullMerger<Pattern> patternMerger = new NotNullMerger();

    WhoisServerMerger() {
    }

    @Override
    public WhoisServer merge(WhoisServer left, WhoisServer right) {
        if (left == null) {
            return right;
        }
        if (right == null) {
            return left;
        }
        WhoisServer merged = (WhoisServer)left.clone();
        merged.setHost(this.stringMerger.merge(left.getHost(), right.getHost()));
        merged.setAvailablePattern(this.patternMerger.merge(left.getAvailablePattern(), right.getAvailablePattern()));
        return merged;
    }
}

