/*
 * Decompiled with CFR 0.152.
 */
package de.malkusch.whoisServerList.compiler.merger;

import de.malkusch.whoisServerList.compiler.helper.ConcurrencyService;
import de.malkusch.whoisServerList.compiler.merger.Merger;
import de.malkusch.whoisServerList.compiler.merger.NotNullMerger;
import de.malkusch.whoisServerList.compiler.merger.RedirectRecorder;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.PropertyKey;
import javax.annotation.concurrent.Immutable;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
final class URLMerger
implements Merger<URL> {
    private final NotNullMerger<URL> notNullMerger = new NotNullMerger();
    private final int timeout;
    @PropertyKey
    private static final String PROPERTY_TIMEOUT = "merger.url.timeout.seconds";
    private final Executor executor;
    private static final Logger LOGGER = LoggerFactory.getLogger(URLMerger.class);
    private static final int SECOND = 1000;

    URLMerger(Properties properties) {
        this(Integer.parseInt(properties.getProperty(PROPERTY_TIMEOUT)));
    }

    URLMerger(int timeout) {
        this.timeout = timeout;
        this.executor = ConcurrencyService.getService().getExecutor();
    }

    @Override
    public URL merge(URL left, URL right) throws InterruptedException {
        URL accessibleRight;
        URL accessibleLeft;
        FutureTask<URL> leftTask = this.buildAccessibleURLTask(left);
        FutureTask<URL> rightTask = this.buildAccessibleURLTask(right);
        this.executor.execute(leftTask);
        this.executor.execute(rightTask);
        try {
            accessibleLeft = leftTask.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            accessibleLeft = null;
        }
        try {
            accessibleRight = rightTask.get(this.timeout, TimeUnit.SECONDS);
        }
        catch (ExecutionException | TimeoutException e) {
            accessibleRight = null;
        }
        return this.notNullMerger.merge(accessibleLeft, accessibleRight);
    }

    private FutureTask<URL> buildAccessibleURLTask(final URL url) {
        return new FutureTask<URL>(new Callable<URL>(){

            @Override
            public URL call() {
                return URLMerger.this.getAccessibleURL(url);
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private URL getAccessibleURL(URL url) {
        if (url == null) {
            return null;
        }
        RedirectRecorder redirectRecorder = new RedirectRecorder();
        HttpClientBuilder clientBuilder = HttpClientBuilder.create();
        clientBuilder.setRedirectStrategy((RedirectStrategy)redirectRecorder);
        try (CloseableHttpClient httpclient = clientBuilder.build();){
            HttpHead httpHead = new HttpHead(url.toURI());
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeout * 1000).build();
            httpHead.setConfig(requestConfig);
            CloseableHttpResponse response = httpclient.execute((HttpUriRequest)httpHead);
            if (response.getStatusLine().getStatusCode() != 200) {
                URL uRL = null;
                return uRL;
            }
            URL redirectedURL = redirectRecorder.getRedirectedLocation();
            if (redirectedURL != null) {
                URL uRL = redirectedURL;
                return uRL;
            }
            URL uRL = url;
            return uRL;
        }
        catch (IOException | URISyntaxException e) {
            LOGGER.warn("Removing inaccessible URL '{}'", (Object)url);
            return null;
        }
    }
}

